/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.javacord.api.AccountType;
import org.javacord.api.DiscordApi;
import org.javacord.api.internal.DiscordApiBuilderDelegate;
import org.javacord.api.util.auth.Authenticator;
import org.javacord.api.util.internal.DelegateFactory;

public class DiscordApiBuilder {
    private final DiscordApiBuilderDelegate delegate = DelegateFactory.createDiscordApiBuilderDelegate();

    public CompletableFuture<DiscordApi> login() {
        return this.delegate.login();
    }

    public Collection<CompletableFuture<DiscordApi>> loginAllShards() {
        return this.loginShards(shard -> true);
    }

    public Collection<CompletableFuture<DiscordApi>> loginShards(IntPredicate shardsCondition) {
        return this.loginShards(IntStream.range(0, this.delegate.getTotalShards()).filter(shardsCondition).toArray());
    }

    public Collection<CompletableFuture<DiscordApi>> loginShards(int ... shards) {
        return this.delegate.loginShards(shards);
    }

    public DiscordApiBuilder setProxySelector(ProxySelector proxySelector) {
        this.delegate.setProxySelector(proxySelector);
        return this;
    }

    public DiscordApiBuilder setProxy(Proxy proxy) {
        this.delegate.setProxy(proxy);
        return this;
    }

    public DiscordApiBuilder setProxyAuthenticator(Authenticator authenticator) {
        this.delegate.setProxyAuthenticator(authenticator);
        return this;
    }

    public DiscordApiBuilder setTrustAllCertificates(boolean trustAllCertificates) {
        this.delegate.setTrustAllCertificates(trustAllCertificates);
        return this;
    }

    public DiscordApiBuilder setToken(String token) {
        this.delegate.setToken(token);
        return this;
    }

    public Optional<String> getToken() {
        return this.delegate.getToken();
    }

    public DiscordApiBuilder setAccountType(AccountType type) {
        this.delegate.setAccountType(type);
        return this;
    }

    public AccountType getAccountType() {
        return this.delegate.getAccountType();
    }

    public DiscordApiBuilder setTotalShards(int totalShards) {
        this.delegate.setTotalShards(totalShards);
        return this;
    }

    public int getTotalShards() {
        return this.delegate.getTotalShards();
    }

    public DiscordApiBuilder setCurrentShard(int currentShard) {
        this.delegate.setCurrentShard(currentShard);
        return this;
    }

    public int getCurrentShard() {
        return this.delegate.getCurrentShard();
    }

    public DiscordApiBuilder setWaitForServersOnStartup(boolean waitForServersOnStartup) {
        this.delegate.setWaitForServersOnStartup(waitForServersOnStartup);
        return this;
    }

    public boolean isWaitingForServersOnStartup() {
        return this.delegate.isWaitingForServersOnStartup();
    }

    public CompletableFuture<DiscordApiBuilder> setRecommendedTotalShards() {
        return this.delegate.setRecommendedTotalShards().thenCompose(nothing -> CompletableFuture.completedFuture(this));
    }
}

