/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api;

import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.PermissionsBuilder;

public class BotInviteBuilder {
    public static final String BASE_LINK = "https://discordapp.com/oauth2/authorize?client_id=%s&scope=bot&permissions=%s";
    private long clientId;
    private Permissions permissions = new PermissionsBuilder().build();

    public BotInviteBuilder(long clientId) {
        this.clientId = clientId;
    }

    public BotInviteBuilder(String clientId) {
        try {
            this.clientId = Long.parseLong(clientId);
        }
        catch (NumberFormatException e) {
            this.clientId = 0L;
        }
    }

    public BotInviteBuilder setPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public String build() {
        return String.format(BASE_LINK, this.clientId, this.permissions.getAllowedBitmask());
    }
}

