package org.javacord.api.listener.channel.server;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link ChannelCategoryAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface ChannelCategoryAttachableListenerManager extends ServerChannelAttachableListenerManager {

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeNsfwFlagListener> addServerChannelChangeNsfwFlagListener(ServerChannelChangeNsfwFlagListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeNsfwFlagListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeNsfwFlagListener}s.
     */
    List<ServerChannelChangeNsfwFlagListener> getServerChannelChangeNsfwFlagListeners();

    /**
     * Adds a listener that implements one or more {@code ChannelCategoryAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends ChannelCategoryAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends ChannelCategoryAttachableListener>> addChannelCategoryAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code ChannelCategoryAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ChannelCategoryAttachableListener & ObjectAttachableListener> void removeChannelCategoryAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code ChannelCategoryAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code ChannelCategoryAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends ChannelCategoryAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getChannelCategoryAttachableListeners();

    /**
     * Removes a listener from this object.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends ChannelCategoryAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
