/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.UpdatableFromCache;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.user.User;
import org.javacord.api.listener.channel.ChannelAttachableListenerManager;

public interface Channel
extends DiscordEntity,
UpdatableFromCache,
ChannelAttachableListenerManager {
    public ChannelType getType();

    default public Optional<GroupChannel> asGroupChannel() {
        if (this instanceof GroupChannel) {
            return Optional.of((GroupChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<PrivateChannel> asPrivateChannel() {
        if (this instanceof PrivateChannel) {
            return Optional.of((PrivateChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<ServerChannel> asServerChannel() {
        if (this instanceof ServerChannel) {
            return Optional.of((ServerChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<ChannelCategory> asChannelCategory() {
        if (this instanceof ChannelCategory) {
            return Optional.of((ChannelCategory)this);
        }
        return Optional.empty();
    }

    default public Optional<Categorizable> asCategorizable() {
        if (this instanceof Categorizable) {
            return Optional.of((Categorizable)((Object)this));
        }
        return Optional.empty();
    }

    default public Optional<ServerTextChannel> asServerTextChannel() {
        if (this instanceof ServerTextChannel) {
            return Optional.of((ServerTextChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<ServerVoiceChannel> asServerVoiceChannel() {
        if (this instanceof ServerVoiceChannel) {
            return Optional.of((ServerVoiceChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<TextChannel> asTextChannel() {
        if (this instanceof TextChannel) {
            return Optional.of((TextChannel)this);
        }
        return Optional.empty();
    }

    default public Optional<VoiceChannel> asVoiceChannel() {
        if (this instanceof VoiceChannel) {
            return Optional.of((VoiceChannel)this);
        }
        return Optional.empty();
    }

    default public boolean canSee(User user) {
        Optional<PrivateChannel> privateChannel = this.asPrivateChannel();
        if (privateChannel.isPresent()) {
            return user.isYourself() || privateChannel.get().getRecipient() == user;
        }
        Optional<GroupChannel> groupChannel = this.asGroupChannel();
        if (groupChannel.isPresent()) {
            return user.isYourself() || groupChannel.get().getMembers().contains(user);
        }
        Optional<ServerChannel> severChannel = this.asServerChannel();
        return !severChannel.isPresent() || severChannel.get().hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.READ_MESSAGES);
    }

    default public boolean canYouSee() {
        return this.canSee(this.getApi().getYourself());
    }

    default public Optional<? extends Channel> getCurrentCachedInstance() {
        return this.getApi().getChannelById(this.getId());
    }

    @Override
    default public CompletableFuture<? extends Channel> getLatestInstance() {
        Optional<? extends Channel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

