/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.javacord.api.AccountType;
import org.javacord.api.DiscordApi;
import org.javacord.api.internal.DiscordApiBuilderDelegate;
import org.javacord.api.util.internal.DelegateFactory;

public class DiscordApiBuilder {
    private final DiscordApiBuilderDelegate delegate = DelegateFactory.createDiscordApiBuilderDelegate();

    public CompletableFuture<DiscordApi> login() {
        return this.delegate.login();
    }

    public Collection<CompletableFuture<DiscordApi>> loginAllShards() {
        return this.loginShards(shard -> true);
    }

    public Collection<CompletableFuture<DiscordApi>> loginShards(IntPredicate shardsCondition) {
        return this.loginShards(IntStream.range(0, this.delegate.getTotalShards()).filter(shardsCondition).toArray());
    }

    public Collection<CompletableFuture<DiscordApi>> loginShards(int ... shards) {
        return this.delegate.loginShards(shards);
    }

    public DiscordApiBuilder setToken(String token) {
        this.delegate.setToken(token);
        return this;
    }

    public DiscordApiBuilder setAccountType(AccountType type) {
        this.delegate.setAccountType(type);
        return this;
    }

    public DiscordApiBuilder setTotalShards(int totalShards) {
        this.delegate.setTotalShards(totalShards);
        return this;
    }

    public DiscordApiBuilder setCurrentShard(int currentShard) {
        this.delegate.setCurrentShard(currentShard);
        return this;
    }

    public DiscordApiBuilder setWaitForServersOnStartup(boolean waitForServersOnStartup) {
        this.delegate.setWaitForServersOnStartup(waitForServersOnStartup);
        return this;
    }

    public CompletableFuture<DiscordApiBuilder> setRecommendedTotalShards() {
        return this.delegate.setRecommendedTotalShards().thenCompose(nothing -> CompletableFuture.completedFuture(this));
    }
}

