package org.javacord.api.listener.message;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.DiscordApi;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link MessageAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface MessageAttachableListenerManager {

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    static ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(DiscordApi api, long messageId, ReactionRemoveAllListener listener) {
        return api.getUncachedMessageUtil()
                  .addReactionRemoveAllListener(messageId,
                                                listener);
    }

    /**
     * Gets a list with all registered {@code ReactionRemoveAllListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionRemoveAllListener}s.
     */
    static List<ReactionRemoveAllListener> getReactionRemoveAllListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionRemoveAllListeners(messageId);
    }

    /**
     * Gets a list with all registered {@code ReactionRemoveAllListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionRemoveAllListener}s.
     */
    static List<ReactionRemoveAllListener> getReactionRemoveAllListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionRemoveAllListeners(messageId);
    }

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(ReactionRemoveAllListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveAllListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    static ListenerManager<ReactionAddListener> addReactionAddListener(DiscordApi api, long messageId, ReactionAddListener listener) {
        return api.getUncachedMessageUtil()
                  .addReactionAddListener(messageId,
                                          listener);
    }

    /**
     * Gets a list with all registered {@code ReactionAddListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    static List<ReactionAddListener> getReactionAddListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionAddListeners(messageId);
    }

    /**
     * Gets a list with all registered {@code ReactionAddListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    static List<ReactionAddListener> getReactionAddListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionAddListeners(messageId);
    }

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets a list with all registered {@code ReactionAddListener}s.
     *
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    static ListenerManager<ReactionRemoveListener> addReactionRemoveListener(DiscordApi api, long messageId, ReactionRemoveListener listener) {
        return api.getUncachedMessageUtil()
                  .addReactionRemoveListener(messageId,
                                             listener);
    }

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    static List<ReactionRemoveListener> getReactionRemoveListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionRemoveListeners(messageId);
    }

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    static List<ReactionRemoveListener> getReactionRemoveListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getReactionRemoveListeners(messageId);
    }

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    static ListenerManager<MessageEditListener> addMessageEditListener(DiscordApi api, long messageId, MessageEditListener listener) {
        return api.getUncachedMessageUtil()
                  .addMessageEditListener(messageId,
                                          listener);
    }

    /**
     * Gets a list with all registered {@code MessageEditListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code MessageEditListener}s.
     */
    static List<MessageEditListener> getMessageEditListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageEditListeners(messageId);
    }

    /**
     * Gets a list with all registered {@code MessageEditListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code MessageEditListener}s.
     */
    static List<MessageEditListener> getMessageEditListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageEditListeners(messageId);
    }

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageEditListener> addMessageEditListener(MessageEditListener listener);

    /**
     * Gets a list with all registered {@code MessageEditListener}s.
     *
     * @return A list with all registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners();

    /**
     * Adds a {@code CachedMessageUnpinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessageUnpinListener> addCachedMessageUnpinListener(CachedMessageUnpinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessageUnpinListener}s.
     *
     * @return A list with all registered {@code CachedMessageUnpinListener}s.
     */
    List<CachedMessageUnpinListener> getCachedMessageUnpinListeners();

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    static ListenerManager<MessageDeleteListener> addMessageDeleteListener(DiscordApi api, long messageId, MessageDeleteListener listener) {
        return api.getUncachedMessageUtil()
                  .addMessageDeleteListener(messageId,
                                            listener);
    }

    /**
     * Gets a list with all registered {@code MessageDeleteListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code MessageDeleteListener}s.
     */
    static List<MessageDeleteListener> getMessageDeleteListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageDeleteListeners(messageId);
    }

    /**
     * Gets a list with all registered {@code MessageDeleteListener}s of a specific message.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @return A list with all registered {@code MessageDeleteListener}s.
     */
    static List<MessageDeleteListener> getMessageDeleteListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageDeleteListeners(messageId);
    }

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageDeleteListener> addMessageDeleteListener(MessageDeleteListener listener);

    /**
     * Gets a list with all registered {@code MessageDeleteListener}s.
     *
     * @return A list with all registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners();

    /**
     * Adds a {@code CachedMessagePinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessagePinListener> addCachedMessagePinListener(CachedMessagePinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessagePinListener}s.
     *
     * @return A list with all registered {@code CachedMessagePinListener}s.
     */
    List<CachedMessagePinListener> getCachedMessagePinListeners();

    /**
     * Adds a listener that implements one or more {@code MessageAttachableListener}s to the message with
     * the given id.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addMessageAttachableListener(DiscordApi api, long messageId, T listener) {
        return api.getUncachedMessageUtil()
                  .addMessageAttachableListener(messageId,
                                                listener);
    }

    /**
     * Adds a listener that implements one or more {@code MessageAttachableListener}s to the message with
     * the given id.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message which should be listened to.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addMessageAttachableListener(DiscordApi api, String messageId, T listener) {
        return api.getUncachedMessageUtil()
                  .addMessageAttachableListener(messageId,
                                                listener);
    }

    /**
     * Removes a listener that implements one or more {@code MessageAttachableListener}s from the message
     * with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> void removeMessageAttachableListener(DiscordApi api, long messageId, T listener) {
        api.getUncachedMessageUtil()
           .removeMessageAttachableListener(messageId,
                                            listener);
    }

    /**
     * Removes a listener that implements one or more {@code MessageAttachableListener}s from the message
     * with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> void removeMessageAttachableListener(DiscordApi api, String messageId, T listener) {
        api.getUncachedMessageUtil()
           .removeMessageAttachableListener(messageId,
                                            listener);
    }

    /**
     * Gets a map with all registered listeners that implement one or more
     * {@code MessageAttachableListener}s and their assigned listener classes they listen to for the
     * message with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code MessageAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getMessageAttachableListeners(DiscordApi api, long messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageAttachableListeners(messageId);
    }

    /**
     * Gets a map with all registered listeners that implement one or more
     * {@code MessageAttachableListener}s and their assigned listener classes they listen to for the
     * message with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code MessageAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getMessageAttachableListeners(DiscordApi api, String messageId) {
        return api.getUncachedMessageUtil()
                  .getMessageAttachableListeners(messageId);
    }

    /**
     * Removes a {@code MessageAttachableListener} from the message with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> void removeListener(DiscordApi api, long messageId, Class<T> listenerClass, T listener) {
        api.getUncachedMessageUtil()
           .removeListener(messageId,
                           listenerClass,
                           listener);
    }

    /**
     * Removes a {@code MessageAttachableListener} from the message with the given id.
     *
     * @param api The discord api instance.
     * @param messageId The id of the message.
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    static <T extends MessageAttachableListener & ObjectAttachableListener> void removeListener(DiscordApi api, String messageId, Class<T> listenerClass, T listener) {
        api.getUncachedMessageUtil()
           .removeListener(messageId,
                           listenerClass,
                           listener);
    }

    /**
     * Adds a listener that implements one or more {@code MessageAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Collection<ListenerManager<T>> addMessageAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code MessageAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeMessageAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code MessageAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code MessageAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getMessageAttachableListeners();

    /**
     * Removes a listener from this entity.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends MessageAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
