package org.javacord.api.listener.channel.group;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.listener.channel.TextChannelAttachableListenerManager;
import org.javacord.api.listener.channel.VoiceChannelAttachableListenerManager;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link GroupChannelAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface GroupChannelAttachableListenerManager extends TextChannelAttachableListenerManager, VoiceChannelAttachableListenerManager {

    /**
     * Adds a {@code GroupChannelChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelChangeNameListener> addGroupChannelChangeNameListener(GroupChannelChangeNameListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelChangeNameListener}s.
     *
     * @return A list with all registered {@code GroupChannelChangeNameListener}s.
     */
    List<GroupChannelChangeNameListener> getGroupChannelChangeNameListeners();

    /**
     * Adds a {@code GroupChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelDeleteListener> addGroupChannelDeleteListener(GroupChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelDeleteListener}s.
     *
     * @return A list with all registered {@code GroupChannelDeleteListener}s.
     */
    List<GroupChannelDeleteListener> getGroupChannelDeleteListeners();

    /**
     * Adds a listener that implements one or more {@code GroupChannelAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The managers for the added listener.
     */
    <T extends GroupChannelAttachableListener & ObjectAttachableListener> Collection<ListenerManager<? extends GroupChannelAttachableListener>> addGroupChannelAttachableListener(T listener);

    /**
     * Removes a listener that implements one or more {@code GroupChannelAttachableListener}s.
     *
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends GroupChannelAttachableListener & ObjectAttachableListener> void removeGroupChannelAttachableListener(T listener);

    /**
     * Gets a map with all registered listeners that implement one or more {@code GroupChannelAttachableListener}s
     * and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code GroupChannelAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends GroupChannelAttachableListener & ObjectAttachableListener> Map<T, List<Class<T>>> getGroupChannelAttachableListeners();

    /**
     * Removes a listener from this entity.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends GroupChannelAttachableListener & ObjectAttachableListener> void removeListener(Class<T> listenerClass, T listener);
}
