package org.javacord.api.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.javacord.api.listener.channel.group.GroupChannelChangeNameListener;
import org.javacord.api.listener.channel.group.GroupChannelCreateListener;
import org.javacord.api.listener.channel.group.GroupChannelDeleteListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeNameListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeNsfwFlagListener;
import org.javacord.api.listener.channel.server.ServerChannelChangeOverwrittenPermissionsListener;
import org.javacord.api.listener.channel.server.ServerChannelChangePositionListener;
import org.javacord.api.listener.channel.server.ServerChannelCreateListener;
import org.javacord.api.listener.channel.server.ServerChannelDeleteListener;
import org.javacord.api.listener.channel.server.text.ServerTextChannelChangeTopicListener;
import org.javacord.api.listener.channel.server.text.WebhooksUpdateListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelChangeBitrateListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelChangeUserLimitListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberJoinListener;
import org.javacord.api.listener.channel.server.voice.ServerVoiceChannelMemberLeaveListener;
import org.javacord.api.listener.channel.user.PrivateChannelCreateListener;
import org.javacord.api.listener.channel.user.PrivateChannelDeleteListener;
import org.javacord.api.listener.connection.LostConnectionListener;
import org.javacord.api.listener.connection.ReconnectListener;
import org.javacord.api.listener.connection.ResumeListener;
import org.javacord.api.listener.message.CachedMessagePinListener;
import org.javacord.api.listener.message.CachedMessageUnpinListener;
import org.javacord.api.listener.message.ChannelPinsUpdateListener;
import org.javacord.api.listener.message.MessageCreateListener;
import org.javacord.api.listener.message.MessageDeleteListener;
import org.javacord.api.listener.message.MessageEditListener;
import org.javacord.api.listener.message.reaction.ReactionAddListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveAllListener;
import org.javacord.api.listener.message.reaction.ReactionRemoveListener;
import org.javacord.api.listener.server.ServerBecomesAvailableListener;
import org.javacord.api.listener.server.ServerBecomesUnavailableListener;
import org.javacord.api.listener.server.ServerChangeAfkChannelListener;
import org.javacord.api.listener.server.ServerChangeAfkTimeoutListener;
import org.javacord.api.listener.server.ServerChangeDefaultMessageNotificationLevelListener;
import org.javacord.api.listener.server.ServerChangeExplicitContentFilterLevelListener;
import org.javacord.api.listener.server.ServerChangeIconListener;
import org.javacord.api.listener.server.ServerChangeMultiFactorAuthenticationLevelListener;
import org.javacord.api.listener.server.ServerChangeNameListener;
import org.javacord.api.listener.server.ServerChangeOwnerListener;
import org.javacord.api.listener.server.ServerChangeRegionListener;
import org.javacord.api.listener.server.ServerChangeSplashListener;
import org.javacord.api.listener.server.ServerChangeSystemChannelListener;
import org.javacord.api.listener.server.ServerChangeVerificationLevelListener;
import org.javacord.api.listener.server.ServerJoinListener;
import org.javacord.api.listener.server.ServerLeaveListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiChangeNameListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiChangeWhitelistedRolesListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiCreateListener;
import org.javacord.api.listener.server.emoji.KnownCustomEmojiDeleteListener;
import org.javacord.api.listener.server.member.ServerMemberBanListener;
import org.javacord.api.listener.server.member.ServerMemberJoinListener;
import org.javacord.api.listener.server.member.ServerMemberLeaveListener;
import org.javacord.api.listener.server.member.ServerMemberUnbanListener;
import org.javacord.api.listener.server.role.RoleChangeColorListener;
import org.javacord.api.listener.server.role.RoleChangeHoistListener;
import org.javacord.api.listener.server.role.RoleChangeMentionableListener;
import org.javacord.api.listener.server.role.RoleChangeNameListener;
import org.javacord.api.listener.server.role.RoleChangePermissionsListener;
import org.javacord.api.listener.server.role.RoleChangePositionListener;
import org.javacord.api.listener.server.role.RoleCreateListener;
import org.javacord.api.listener.server.role.RoleDeleteListener;
import org.javacord.api.listener.server.role.UserRoleAddListener;
import org.javacord.api.listener.server.role.UserRoleRemoveListener;
import org.javacord.api.listener.user.UserChangeActivityListener;
import org.javacord.api.listener.user.UserChangeAvatarListener;
import org.javacord.api.listener.user.UserChangeDeafenedListener;
import org.javacord.api.listener.user.UserChangeDiscriminatorListener;
import org.javacord.api.listener.user.UserChangeMutedListener;
import org.javacord.api.listener.user.UserChangeNameListener;
import org.javacord.api.listener.user.UserChangeNicknameListener;
import org.javacord.api.listener.user.UserChangeSelfDeafenedListener;
import org.javacord.api.listener.user.UserChangeSelfMutedListener;
import org.javacord.api.listener.user.UserChangeStatusListener;
import org.javacord.api.listener.user.UserStartTypingListener;
import org.javacord.api.util.event.ListenerManager;

/**
 * This class can be used to add and retrieve {@link GloballyAttachableListener}s.
 */
@Generated("listener-manager-generation.gradle")
public interface GloballyAttachableListenerManager {

    /**
     * Adds a {@code UserChangeSelfMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfMutedListener> addUserChangeSelfMutedListener(UserChangeSelfMutedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeSelfMutedListener}s.
     *
     * @return A list with all registered {@code UserChangeSelfMutedListener}s.
     */
    List<UserChangeSelfMutedListener> getUserChangeSelfMutedListeners();

    /**
     * Adds a {@code UserChangeSelfDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeSelfDeafenedListener> addUserChangeSelfDeafenedListener(UserChangeSelfDeafenedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeSelfDeafenedListener}s.
     *
     * @return A list with all registered {@code UserChangeSelfDeafenedListener}s.
     */
    List<UserChangeSelfDeafenedListener> getUserChangeSelfDeafenedListeners();

    /**
     * Adds a {@code UserChangeDiscriminatorListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDiscriminatorListener> addUserChangeDiscriminatorListener(UserChangeDiscriminatorListener listener);

    /**
     * Gets a list with all registered {@code UserChangeDiscriminatorListener}s.
     *
     * @return A list with all registered {@code UserChangeDiscriminatorListener}s.
     */
    List<UserChangeDiscriminatorListener> getUserChangeDiscriminatorListeners();

    /**
     * Adds a {@code UserChangeActivityListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeActivityListener> addUserChangeActivityListener(UserChangeActivityListener listener);

    /**
     * Gets a list with all registered {@code UserChangeActivityListener}s.
     *
     * @return A list with all registered {@code UserChangeActivityListener}s.
     */
    List<UserChangeActivityListener> getUserChangeActivityListeners();

    /**
     * Adds a {@code UserChangeMutedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeMutedListener> addUserChangeMutedListener(UserChangeMutedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeMutedListener}s.
     *
     * @return A list with all registered {@code UserChangeMutedListener}s.
     */
    List<UserChangeMutedListener> getUserChangeMutedListeners();

    /**
     * Adds a {@code UserChangeDeafenedListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeDeafenedListener> addUserChangeDeafenedListener(UserChangeDeafenedListener listener);

    /**
     * Gets a list with all registered {@code UserChangeDeafenedListener}s.
     *
     * @return A list with all registered {@code UserChangeDeafenedListener}s.
     */
    List<UserChangeDeafenedListener> getUserChangeDeafenedListeners();

    /**
     * Adds a {@code UserStartTypingListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserStartTypingListener> addUserStartTypingListener(UserStartTypingListener listener);

    /**
     * Gets a list with all registered {@code UserStartTypingListener}s.
     *
     * @return A list with all registered {@code UserStartTypingListener}s.
     */
    List<UserStartTypingListener> getUserStartTypingListeners();

    /**
     * Adds a {@code UserChangeNicknameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNicknameListener> addUserChangeNicknameListener(UserChangeNicknameListener listener);

    /**
     * Gets a list with all registered {@code UserChangeNicknameListener}s.
     *
     * @return A list with all registered {@code UserChangeNicknameListener}s.
     */
    List<UserChangeNicknameListener> getUserChangeNicknameListeners();

    /**
     * Adds a {@code UserChangeAvatarListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeAvatarListener> addUserChangeAvatarListener(UserChangeAvatarListener listener);

    /**
     * Gets a list with all registered {@code UserChangeAvatarListener}s.
     *
     * @return A list with all registered {@code UserChangeAvatarListener}s.
     */
    List<UserChangeAvatarListener> getUserChangeAvatarListeners();

    /**
     * Adds a {@code UserChangeStatusListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeStatusListener> addUserChangeStatusListener(UserChangeStatusListener listener);

    /**
     * Gets a list with all registered {@code UserChangeStatusListener}s.
     *
     * @return A list with all registered {@code UserChangeStatusListener}s.
     */
    List<UserChangeStatusListener> getUserChangeStatusListeners();

    /**
     * Adds a {@code UserChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserChangeNameListener> addUserChangeNameListener(UserChangeNameListener listener);

    /**
     * Gets a list with all registered {@code UserChangeNameListener}s.
     *
     * @return A list with all registered {@code UserChangeNameListener}s.
     */
    List<UserChangeNameListener> getUserChangeNameListeners();

    /**
     * Adds a {@code ResumeListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ResumeListener> addResumeListener(ResumeListener listener);

    /**
     * Gets a list with all registered {@code ResumeListener}s.
     *
     * @return A list with all registered {@code ResumeListener}s.
     */
    List<ResumeListener> getResumeListeners();

    /**
     * Adds a {@code LostConnectionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<LostConnectionListener> addLostConnectionListener(LostConnectionListener listener);

    /**
     * Gets a list with all registered {@code LostConnectionListener}s.
     *
     * @return A list with all registered {@code LostConnectionListener}s.
     */
    List<LostConnectionListener> getLostConnectionListeners();

    /**
     * Adds a {@code ReconnectListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReconnectListener> addReconnectListener(ReconnectListener listener);

    /**
     * Gets a list with all registered {@code ReconnectListener}s.
     *
     * @return A list with all registered {@code ReconnectListener}s.
     */
    List<ReconnectListener> getReconnectListeners();

    /**
     * Adds a {@code GroupChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelCreateListener> addGroupChannelCreateListener(GroupChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelCreateListener}s.
     *
     * @return A list with all registered {@code GroupChannelCreateListener}s.
     */
    List<GroupChannelCreateListener> getGroupChannelCreateListeners();

    /**
     * Adds a {@code GroupChannelChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelChangeNameListener> addGroupChannelChangeNameListener(GroupChannelChangeNameListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelChangeNameListener}s.
     *
     * @return A list with all registered {@code GroupChannelChangeNameListener}s.
     */
    List<GroupChannelChangeNameListener> getGroupChannelChangeNameListeners();

    /**
     * Adds a {@code GroupChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<GroupChannelDeleteListener> addGroupChannelDeleteListener(GroupChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code GroupChannelDeleteListener}s.
     *
     * @return A list with all registered {@code GroupChannelDeleteListener}s.
     */
    List<GroupChannelDeleteListener> getGroupChannelDeleteListeners();

    /**
     * Adds a {@code PrivateChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelCreateListener> addPrivateChannelCreateListener(PrivateChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code PrivateChannelCreateListener}s.
     *
     * @return A list with all registered {@code PrivateChannelCreateListener}s.
     */
    List<PrivateChannelCreateListener> getPrivateChannelCreateListeners();

    /**
     * Adds a {@code PrivateChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<PrivateChannelDeleteListener> addPrivateChannelDeleteListener(PrivateChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code PrivateChannelDeleteListener}s.
     *
     * @return A list with all registered {@code PrivateChannelDeleteListener}s.
     */
    List<PrivateChannelDeleteListener> getPrivateChannelDeleteListeners();

    /**
     * Adds a {@code ServerChannelChangePositionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangePositionListener> addServerChannelChangePositionListener(ServerChannelChangePositionListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangePositionListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangePositionListener}s.
     */
    List<ServerChannelChangePositionListener> getServerChannelChangePositionListeners();

    /**
     * Adds a {@code ServerChannelChangeOverwrittenPermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeOverwrittenPermissionsListener> addServerChannelChangeOverwrittenPermissionsListener(ServerChannelChangeOverwrittenPermissionsListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeOverwrittenPermissionsListener}s.
     */
    List<ServerChannelChangeOverwrittenPermissionsListener> getServerChannelChangeOverwrittenPermissionsListeners();

    /**
     * Adds a {@code ServerChannelDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelDeleteListener> addServerChannelDeleteListener(ServerChannelDeleteListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelDeleteListener}s.
     *
     * @return A list with all registered {@code ServerChannelDeleteListener}s.
     */
    List<ServerChannelDeleteListener> getServerChannelDeleteListeners();

    /**
     * Adds a {@code ServerChannelCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelCreateListener> addServerChannelCreateListener(ServerChannelCreateListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelCreateListener}s.
     *
     * @return A list with all registered {@code ServerChannelCreateListener}s.
     */
    List<ServerChannelCreateListener> getServerChannelCreateListeners();

    /**
     * Adds a {@code WebhooksUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<WebhooksUpdateListener> addWebhooksUpdateListener(WebhooksUpdateListener listener);

    /**
     * Gets a list with all registered {@code WebhooksUpdateListener}s.
     *
     * @return A list with all registered {@code WebhooksUpdateListener}s.
     */
    List<WebhooksUpdateListener> getWebhooksUpdateListeners();

    /**
     * Adds a {@code ServerTextChannelChangeTopicListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerTextChannelChangeTopicListener> addServerTextChannelChangeTopicListener(ServerTextChannelChangeTopicListener listener);

    /**
     * Gets a list with all registered {@code ServerTextChannelChangeTopicListener}s.
     *
     * @return A list with all registered {@code ServerTextChannelChangeTopicListener}s.
     */
    List<ServerTextChannelChangeTopicListener> getServerTextChannelChangeTopicListeners();

    /**
     * Adds a {@code ServerChannelChangeNsfwFlagListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeNsfwFlagListener> addServerChannelChangeNsfwFlagListener(ServerChannelChangeNsfwFlagListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeNsfwFlagListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeNsfwFlagListener}s.
     */
    List<ServerChannelChangeNsfwFlagListener> getServerChannelChangeNsfwFlagListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberLeaveListener> addServerVoiceChannelMemberLeaveListener(ServerVoiceChannelMemberLeaveListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelMemberLeaveListener}s.
     */
    List<ServerVoiceChannelMemberLeaveListener> getServerVoiceChannelMemberLeaveListeners();

    /**
     * Adds a {@code ServerVoiceChannelChangeUserLimitListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelChangeUserLimitListener> addServerVoiceChannelChangeUserLimitListener(ServerVoiceChannelChangeUserLimitListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelChangeUserLimitListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelChangeUserLimitListener}s.
     */
    List<ServerVoiceChannelChangeUserLimitListener> getServerVoiceChannelChangeUserLimitListeners();

    /**
     * Adds a {@code ServerVoiceChannelChangeBitrateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelChangeBitrateListener> addServerVoiceChannelChangeBitrateListener(ServerVoiceChannelChangeBitrateListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelChangeBitrateListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelChangeBitrateListener}s.
     */
    List<ServerVoiceChannelChangeBitrateListener> getServerVoiceChannelChangeBitrateListeners();

    /**
     * Adds a {@code ServerVoiceChannelMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerVoiceChannelMemberJoinListener> addServerVoiceChannelMemberJoinListener(ServerVoiceChannelMemberJoinListener listener);

    /**
     * Gets a list with all registered {@code ServerVoiceChannelMemberJoinListener}s.
     *
     * @return A list with all registered {@code ServerVoiceChannelMemberJoinListener}s.
     */
    List<ServerVoiceChannelMemberJoinListener> getServerVoiceChannelMemberJoinListeners();

    /**
     * Adds a {@code ServerChannelChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChannelChangeNameListener> addServerChannelChangeNameListener(ServerChannelChangeNameListener listener);

    /**
     * Gets a list with all registered {@code ServerChannelChangeNameListener}s.
     *
     * @return A list with all registered {@code ServerChannelChangeNameListener}s.
     */
    List<ServerChannelChangeNameListener> getServerChannelChangeNameListeners();

    /**
     * Adds a {@code ReactionRemoveAllListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveAllListener> addReactionRemoveAllListener(ReactionRemoveAllListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveAllListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveAllListener}s.
     */
    List<ReactionRemoveAllListener> getReactionRemoveAllListeners();

    /**
     * Adds a {@code ReactionAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionAddListener> addReactionAddListener(ReactionAddListener listener);

    /**
     * Gets a list with all registered {@code ReactionAddListener}s.
     *
     * @return A list with all registered {@code ReactionAddListener}s.
     */
    List<ReactionAddListener> getReactionAddListeners();

    /**
     * Adds a {@code ReactionRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ReactionRemoveListener> addReactionRemoveListener(ReactionRemoveListener listener);

    /**
     * Gets a list with all registered {@code ReactionRemoveListener}s.
     *
     * @return A list with all registered {@code ReactionRemoveListener}s.
     */
    List<ReactionRemoveListener> getReactionRemoveListeners();

    /**
     * Adds a {@code MessageEditListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageEditListener> addMessageEditListener(MessageEditListener listener);

    /**
     * Gets a list with all registered {@code MessageEditListener}s.
     *
     * @return A list with all registered {@code MessageEditListener}s.
     */
    List<MessageEditListener> getMessageEditListeners();

    /**
     * Adds a {@code CachedMessageUnpinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessageUnpinListener> addCachedMessageUnpinListener(CachedMessageUnpinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessageUnpinListener}s.
     *
     * @return A list with all registered {@code CachedMessageUnpinListener}s.
     */
    List<CachedMessageUnpinListener> getCachedMessageUnpinListeners();

    /**
     * Adds a {@code ChannelPinsUpdateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ChannelPinsUpdateListener> addChannelPinsUpdateListener(ChannelPinsUpdateListener listener);

    /**
     * Gets a list with all registered {@code ChannelPinsUpdateListener}s.
     *
     * @return A list with all registered {@code ChannelPinsUpdateListener}s.
     */
    List<ChannelPinsUpdateListener> getChannelPinsUpdateListeners();

    /**
     * Adds a {@code MessageCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageCreateListener> addMessageCreateListener(MessageCreateListener listener);

    /**
     * Gets a list with all registered {@code MessageCreateListener}s.
     *
     * @return A list with all registered {@code MessageCreateListener}s.
     */
    List<MessageCreateListener> getMessageCreateListeners();

    /**
     * Adds a {@code MessageDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<MessageDeleteListener> addMessageDeleteListener(MessageDeleteListener listener);

    /**
     * Gets a list with all registered {@code MessageDeleteListener}s.
     *
     * @return A list with all registered {@code MessageDeleteListener}s.
     */
    List<MessageDeleteListener> getMessageDeleteListeners();

    /**
     * Adds a {@code CachedMessagePinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<CachedMessagePinListener> addCachedMessagePinListener(CachedMessagePinListener listener);

    /**
     * Gets a list with all registered {@code CachedMessagePinListener}s.
     *
     * @return A list with all registered {@code CachedMessagePinListener}s.
     */
    List<CachedMessagePinListener> getCachedMessagePinListeners();

    /**
     * Adds a {@code ServerChangeDefaultMessageNotificationLevelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeDefaultMessageNotificationLevelListener> addServerChangeDefaultMessageNotificationLevelListener(ServerChangeDefaultMessageNotificationLevelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeDefaultMessageNotificationLevelListener}s.
     *
     * @return A list with all registered {@code ServerChangeDefaultMessageNotificationLevelListener}s.
     */
    List<ServerChangeDefaultMessageNotificationLevelListener> getServerChangeDefaultMessageNotificationLevelListeners();

    /**
     * Adds a {@code ServerChangeSystemChannelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeSystemChannelListener> addServerChangeSystemChannelListener(ServerChangeSystemChannelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeSystemChannelListener}s.
     *
     * @return A list with all registered {@code ServerChangeSystemChannelListener}s.
     */
    List<ServerChangeSystemChannelListener> getServerChangeSystemChannelListeners();

    /**
     * Adds a {@code ServerChangeRegionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeRegionListener> addServerChangeRegionListener(ServerChangeRegionListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeRegionListener}s.
     *
     * @return A list with all registered {@code ServerChangeRegionListener}s.
     */
    List<ServerChangeRegionListener> getServerChangeRegionListeners();

    /**
     * Adds a {@code ServerChangeVerificationLevelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeVerificationLevelListener> addServerChangeVerificationLevelListener(ServerChangeVerificationLevelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeVerificationLevelListener}s.
     *
     * @return A list with all registered {@code ServerChangeVerificationLevelListener}s.
     */
    List<ServerChangeVerificationLevelListener> getServerChangeVerificationLevelListeners();

    /**
     * Adds a {@code RoleChangePositionListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangePositionListener> addRoleChangePositionListener(RoleChangePositionListener listener);

    /**
     * Gets a list with all registered {@code RoleChangePositionListener}s.
     *
     * @return A list with all registered {@code RoleChangePositionListener}s.
     */
    List<RoleChangePositionListener> getRoleChangePositionListeners();

    /**
     * Adds a {@code UserRoleAddListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleAddListener> addUserRoleAddListener(UserRoleAddListener listener);

    /**
     * Gets a list with all registered {@code UserRoleAddListener}s.
     *
     * @return A list with all registered {@code UserRoleAddListener}s.
     */
    List<UserRoleAddListener> getUserRoleAddListeners();

    /**
     * Adds a {@code RoleChangeMentionableListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeMentionableListener> addRoleChangeMentionableListener(RoleChangeMentionableListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeMentionableListener}s.
     *
     * @return A list with all registered {@code RoleChangeMentionableListener}s.
     */
    List<RoleChangeMentionableListener> getRoleChangeMentionableListeners();

    /**
     * Adds a {@code RoleChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeNameListener> addRoleChangeNameListener(RoleChangeNameListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeNameListener}s.
     *
     * @return A list with all registered {@code RoleChangeNameListener}s.
     */
    List<RoleChangeNameListener> getRoleChangeNameListeners();

    /**
     * Adds a {@code RoleChangePermissionsListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangePermissionsListener> addRoleChangePermissionsListener(RoleChangePermissionsListener listener);

    /**
     * Gets a list with all registered {@code RoleChangePermissionsListener}s.
     *
     * @return A list with all registered {@code RoleChangePermissionsListener}s.
     */
    List<RoleChangePermissionsListener> getRoleChangePermissionsListeners();

    /**
     * Adds a {@code RoleDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleDeleteListener> addRoleDeleteListener(RoleDeleteListener listener);

    /**
     * Gets a list with all registered {@code RoleDeleteListener}s.
     *
     * @return A list with all registered {@code RoleDeleteListener}s.
     */
    List<RoleDeleteListener> getRoleDeleteListeners();

    /**
     * Adds a {@code RoleChangeColorListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeColorListener> addRoleChangeColorListener(RoleChangeColorListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeColorListener}s.
     *
     * @return A list with all registered {@code RoleChangeColorListener}s.
     */
    List<RoleChangeColorListener> getRoleChangeColorListeners();

    /**
     * Adds a {@code UserRoleRemoveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<UserRoleRemoveListener> addUserRoleRemoveListener(UserRoleRemoveListener listener);

    /**
     * Gets a list with all registered {@code UserRoleRemoveListener}s.
     *
     * @return A list with all registered {@code UserRoleRemoveListener}s.
     */
    List<UserRoleRemoveListener> getUserRoleRemoveListeners();

    /**
     * Adds a {@code RoleCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleCreateListener> addRoleCreateListener(RoleCreateListener listener);

    /**
     * Gets a list with all registered {@code RoleCreateListener}s.
     *
     * @return A list with all registered {@code RoleCreateListener}s.
     */
    List<RoleCreateListener> getRoleCreateListeners();

    /**
     * Adds a {@code RoleChangeHoistListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<RoleChangeHoistListener> addRoleChangeHoistListener(RoleChangeHoistListener listener);

    /**
     * Gets a list with all registered {@code RoleChangeHoistListener}s.
     *
     * @return A list with all registered {@code RoleChangeHoistListener}s.
     */
    List<RoleChangeHoistListener> getRoleChangeHoistListeners();

    /**
     * Adds a {@code ServerChangeIconListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeIconListener> addServerChangeIconListener(ServerChangeIconListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeIconListener}s.
     *
     * @return A list with all registered {@code ServerChangeIconListener}s.
     */
    List<ServerChangeIconListener> getServerChangeIconListeners();

    /**
     * Adds a {@code KnownCustomEmojiChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<KnownCustomEmojiChangeNameListener> addKnownCustomEmojiChangeNameListener(KnownCustomEmojiChangeNameListener listener);

    /**
     * Gets a list with all registered {@code KnownCustomEmojiChangeNameListener}s.
     *
     * @return A list with all registered {@code KnownCustomEmojiChangeNameListener}s.
     */
    List<KnownCustomEmojiChangeNameListener> getKnownCustomEmojiChangeNameListeners();

    /**
     * Adds a {@code KnownCustomEmojiCreateListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<KnownCustomEmojiCreateListener> addKnownCustomEmojiCreateListener(KnownCustomEmojiCreateListener listener);

    /**
     * Gets a list with all registered {@code KnownCustomEmojiCreateListener}s.
     *
     * @return A list with all registered {@code KnownCustomEmojiCreateListener}s.
     */
    List<KnownCustomEmojiCreateListener> getKnownCustomEmojiCreateListeners();

    /**
     * Adds a {@code KnownCustomEmojiDeleteListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<KnownCustomEmojiDeleteListener> addKnownCustomEmojiDeleteListener(KnownCustomEmojiDeleteListener listener);

    /**
     * Gets a list with all registered {@code KnownCustomEmojiDeleteListener}s.
     *
     * @return A list with all registered {@code KnownCustomEmojiDeleteListener}s.
     */
    List<KnownCustomEmojiDeleteListener> getKnownCustomEmojiDeleteListeners();

    /**
     * Adds a {@code KnownCustomEmojiChangeWhitelistedRolesListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<KnownCustomEmojiChangeWhitelistedRolesListener> addKnownCustomEmojiChangeWhitelistedRolesListener(KnownCustomEmojiChangeWhitelistedRolesListener listener);

    /**
     * Gets a list with all registered {@code KnownCustomEmojiChangeWhitelistedRolesListener}s.
     *
     * @return A list with all registered {@code KnownCustomEmojiChangeWhitelistedRolesListener}s.
     */
    List<KnownCustomEmojiChangeWhitelistedRolesListener> getKnownCustomEmojiChangeWhitelistedRolesListeners();

    /**
     * Adds a {@code ServerJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerJoinListener> addServerJoinListener(ServerJoinListener listener);

    /**
     * Gets a list with all registered {@code ServerJoinListener}s.
     *
     * @return A list with all registered {@code ServerJoinListener}s.
     */
    List<ServerJoinListener> getServerJoinListeners();

    /**
     * Adds a {@code ServerChangeNameListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeNameListener> addServerChangeNameListener(ServerChangeNameListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeNameListener}s.
     *
     * @return A list with all registered {@code ServerChangeNameListener}s.
     */
    List<ServerChangeNameListener> getServerChangeNameListeners();

    /**
     * Adds a {@code ServerMemberLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberLeaveListener> addServerMemberLeaveListener(ServerMemberLeaveListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberLeaveListener}s.
     *
     * @return A list with all registered {@code ServerMemberLeaveListener}s.
     */
    List<ServerMemberLeaveListener> getServerMemberLeaveListeners();

    /**
     * Adds a {@code ServerMemberBanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberBanListener> addServerMemberBanListener(ServerMemberBanListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberBanListener}s.
     *
     * @return A list with all registered {@code ServerMemberBanListener}s.
     */
    List<ServerMemberBanListener> getServerMemberBanListeners();

    /**
     * Adds a {@code ServerMemberUnbanListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberUnbanListener> addServerMemberUnbanListener(ServerMemberUnbanListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberUnbanListener}s.
     *
     * @return A list with all registered {@code ServerMemberUnbanListener}s.
     */
    List<ServerMemberUnbanListener> getServerMemberUnbanListeners();

    /**
     * Adds a {@code ServerMemberJoinListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerMemberJoinListener> addServerMemberJoinListener(ServerMemberJoinListener listener);

    /**
     * Gets a list with all registered {@code ServerMemberJoinListener}s.
     *
     * @return A list with all registered {@code ServerMemberJoinListener}s.
     */
    List<ServerMemberJoinListener> getServerMemberJoinListeners();

    /**
     * Adds a {@code ServerChangeAfkTimeoutListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeAfkTimeoutListener> addServerChangeAfkTimeoutListener(ServerChangeAfkTimeoutListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeAfkTimeoutListener}s.
     *
     * @return A list with all registered {@code ServerChangeAfkTimeoutListener}s.
     */
    List<ServerChangeAfkTimeoutListener> getServerChangeAfkTimeoutListeners();

    /**
     * Adds a {@code ServerChangeExplicitContentFilterLevelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeExplicitContentFilterLevelListener> addServerChangeExplicitContentFilterLevelListener(ServerChangeExplicitContentFilterLevelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeExplicitContentFilterLevelListener}s.
     *
     * @return A list with all registered {@code ServerChangeExplicitContentFilterLevelListener}s.
     */
    List<ServerChangeExplicitContentFilterLevelListener> getServerChangeExplicitContentFilterLevelListeners();

    /**
     * Adds a {@code ServerChangeSplashListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeSplashListener> addServerChangeSplashListener(ServerChangeSplashListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeSplashListener}s.
     *
     * @return A list with all registered {@code ServerChangeSplashListener}s.
     */
    List<ServerChangeSplashListener> getServerChangeSplashListeners();

    /**
     * Adds a {@code ServerChangeMultiFactorAuthenticationLevelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeMultiFactorAuthenticationLevelListener> addServerChangeMultiFactorAuthenticationLevelListener(ServerChangeMultiFactorAuthenticationLevelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeMultiFactorAuthenticationLevelListener}s.
     *
     * @return A list with all registered {@code ServerChangeMultiFactorAuthenticationLevelListener}s.
     */
    List<ServerChangeMultiFactorAuthenticationLevelListener> getServerChangeMultiFactorAuthenticationLevelListeners();

    /**
     * Adds a {@code ServerChangeAfkChannelListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeAfkChannelListener> addServerChangeAfkChannelListener(ServerChangeAfkChannelListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeAfkChannelListener}s.
     *
     * @return A list with all registered {@code ServerChangeAfkChannelListener}s.
     */
    List<ServerChangeAfkChannelListener> getServerChangeAfkChannelListeners();

    /**
     * Adds a {@code ServerBecomesUnavailableListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerBecomesUnavailableListener> addServerBecomesUnavailableListener(ServerBecomesUnavailableListener listener);

    /**
     * Gets a list with all registered {@code ServerBecomesUnavailableListener}s.
     *
     * @return A list with all registered {@code ServerBecomesUnavailableListener}s.
     */
    List<ServerBecomesUnavailableListener> getServerBecomesUnavailableListeners();

    /**
     * Adds a {@code ServerChangeOwnerListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerChangeOwnerListener> addServerChangeOwnerListener(ServerChangeOwnerListener listener);

    /**
     * Gets a list with all registered {@code ServerChangeOwnerListener}s.
     *
     * @return A list with all registered {@code ServerChangeOwnerListener}s.
     */
    List<ServerChangeOwnerListener> getServerChangeOwnerListeners();

    /**
     * Adds a {@code ServerBecomesAvailableListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerBecomesAvailableListener> addServerBecomesAvailableListener(ServerBecomesAvailableListener listener);

    /**
     * Gets a list with all registered {@code ServerBecomesAvailableListener}s.
     *
     * @return A list with all registered {@code ServerBecomesAvailableListener}s.
     */
    List<ServerBecomesAvailableListener> getServerBecomesAvailableListeners();

    /**
     * Adds a {@code ServerLeaveListener}.
     *
     * @param listener The listener to add.
     * @return The manager of the listener.
     */
    ListenerManager<ServerLeaveListener> addServerLeaveListener(ServerLeaveListener listener);

    /**
     * Gets a list with all registered {@code ServerLeaveListener}s.
     *
     * @return A list with all registered {@code ServerLeaveListener}s.
     */
    List<ServerLeaveListener> getServerLeaveListeners();

    /**
     * Adds a {@code GloballyAttachableListener}.
     * Adding a listener multiple times will only add it once
     * and return the same listener manager on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to add.
     * @param <T> The type of the listener.
     * @return The manager for the added listener.
     */
    <T extends GloballyAttachableListener> ListenerManager<T> addListener(Class<T> listenerClass, T listener);

    /**
     * Adds a listener that implements one or more {@code GloballyAttachableListener}s.
     * Adding a listener multiple times will only add it once
     * and return the same listener managers on each invocation.
     * The order of invocation is according to first addition.
     *
     * @param listener The listener to add.
     * @return The managers for the added listener.
     */
    Collection<ListenerManager<? extends GloballyAttachableListener>> addListener(GloballyAttachableListener listener);

    /**
     * Removes a listener that implements one or more {@code GloballyAttachableListener}s.
     *
     * @param listener The listener to remove.
     */
    void removeListener(GloballyAttachableListener listener);

    /**
     * Removes a {@code GloballyAttachableListener}.
     *
     * @param listenerClass The listener class.
     * @param listener The listener to remove.
     * @param <T> The type of the listener.
     */
    <T extends GloballyAttachableListener> void removeListener(Class<T> listenerClass, T listener);

    /**
     * Gets a map with all registered listeners that implement one or more
     * {@code GloballyAttachableListener}s and their assigned listener classes they listen to.
     *
     * @param <T> The type of the listeners.
     * @return A map with all registered listeners that implement one or more
     *         {@code GloballyAttachableListener}s and their assigned listener
     *         classes they listen to.
     */
    <T extends GloballyAttachableListener> Map<T, List<Class<T>>> getListeners();
}
