/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jaudiolibs.pipes.graph.Easing;

final class SplineEasing
implements Easing {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private ArrayList lengths = new ArrayList();

    public SplineEasing(double x1, double y1, double x2, double y2) {
        if (x1 < 0.0 || x1 > 1.0 || y1 < 0.0 || y1 > 1.0 || x2 < 0.0 || x2 > 1.0 || y2 < 0.0 || y2 > 1.0) {
            throw new IllegalArgumentException("Control points must be in the range [0, 1]:");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        double prevX = 0.0;
        double prevY = 0.0;
        double prevLength = 0.0;
        for (double t = (double)0.01f; t <= 1.0; t += (double)0.01f) {
            Point2D.Double xy = this.getXY(t);
            double length = prevLength + Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            LengthItem lengthItem = new LengthItem(length, t);
            this.lengths.add(lengthItem);
            prevLength = length;
            prevX = xy.x;
            prevY = xy.y;
        }
        for (int i = 0; i < this.lengths.size(); ++i) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i);
            lengthItem.setFraction(prevLength);
        }
    }

    private Point2D.Double getXY(double t) {
        double invT = 1.0 - t;
        double b1 = 3.0 * t * (invT * invT);
        double b2 = 3.0 * (t * t) * invT;
        double b3 = t * t * t;
        Point2D.Double xy = new Point2D.Double(b1 * this.x1 + b2 * this.x2 + b3, b1 * this.y1 + b2 * this.y2 + b3);
        return xy;
    }

    private double getY(double t) {
        double invT = 1.0 - t;
        double b1 = 3.0 * t * (invT * invT);
        double b2 = 3.0 * (t * t) * invT;
        double b3 = t * t * t;
        return b1 * this.y1 + b2 * this.y2 + b3;
    }

    @Override
    public double calculate(double lengthFraction) {
        double interpolatedT = 1.0;
        double prevT = 0.0;
        double prevLength = 0.0;
        for (int i = 0; i < this.lengths.size(); ++i) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i);
            double fraction = lengthItem.getFraction();
            double t = lengthItem.getT();
            if (lengthFraction <= fraction) {
                double proportion = (lengthFraction - prevLength) / (fraction - prevLength);
                interpolatedT = prevT + proportion * (t - prevT);
                return this.getY(interpolatedT);
            }
            prevLength = fraction;
            prevT = t;
        }
        return this.getY(interpolatedT);
    }

    static class LengthItem {
        double length;
        double t;
        double fraction;

        LengthItem(double length, double t, double fraction) {
            this.length = length;
            this.t = t;
            this.fraction = fraction;
        }

        LengthItem(double length, double t) {
            this.length = length;
            this.t = t;
        }

        public double getLength() {
            return this.length;
        }

        public double getT() {
            return this.t;
        }

        public double getFraction() {
            return this.fraction;
        }

        void setFraction(double totalLength) {
            this.fraction = this.length / totalLength;
        }
    }
}

