/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.jaudiolibs.pipes.graph.Easing;
import org.jaudiolibs.pipes.graph.Graph;
import org.jaudiolibs.pipes.graph.Linkable;

public final class Property
implements Graph.Dependent {
    private static final long TO_NANO = 1000000000L;
    private final List<Link> links = new CopyOnWriteArrayList<Link>();
    private Animator animator;
    private double value;
    private Graph graph;

    public Property set(double value) {
        this.finishAnimating();
        this.setImpl(value);
        return this;
    }

    public double get() {
        return this.value;
    }

    public Property link(DoubleConsumer consumer) {
        Link dl = new Link();
        dl.link(consumer);
        return this;
    }

    public Linkable.Double values() {
        return new Link();
    }

    public Property clearLinks() {
        this.links.clear();
        return this;
    }

    public Animator animator() {
        if (this.animator == null) {
            this.animator = new Animator(this);
        }
        return this.animator;
    }

    public Animator to(double ... to) {
        return this.animator().to(to);
    }

    @Override
    public void attach(Graph graph) {
        this.graph = graph;
    }

    @Override
    public void detach(Graph graph) {
        this.finishAnimating();
        this.graph = null;
    }

    @Override
    public void update() {
        if (this.animator != null) {
            this.animator.tick();
        }
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isAnimating();
    }

    private void setImpl(double value) {
        this.value = value;
        this.updateLinks();
    }

    private void finishAnimating() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    private void updateLinks() {
        this.links.forEach(l -> ((Link)l).fire(this.value));
    }

    public static class Animator {
        private static final long[] DEFAULT_IN = new long[]{0L};
        private static final Easing[] DEFAULT_EASING = new Easing[]{Easing.linear};
        private Property property;
        int index;
        private double[] to;
        private long[] in;
        private Easing[] easing;
        private double fromValue;
        private long fromTime;
        private boolean animating;
        private Consumer<Property> onDoneConsumer;
        private long overrun;

        private Animator(Property p) {
            this.property = p;
            this.in = DEFAULT_IN;
            this.easing = DEFAULT_EASING;
        }

        private void attach(Property p) {
            this.property = p;
        }

        public Animator to(double ... to) {
            if (to.length < 1) {
                throw new IllegalArgumentException();
            }
            this.to = to;
            this.index = 0;
            this.in = DEFAULT_IN;
            this.easing = DEFAULT_EASING;
            this.fromValue = this.property.value;
            this.fromTime = this.property.graph.nanos();
            if (!this.animating) {
                this.animating = true;
            }
            return this;
        }

        public Animator in(double ... in) {
            if (in.length < 1) {
                this.in = DEFAULT_IN;
            } else {
                this.in = new long[in.length];
                for (int i = 0; i < in.length; ++i) {
                    this.in[i] = (long)(in[i] * 1.0E9);
                }
                this.in[0] = Math.max(0L, this.in[0] - this.overrun);
            }
            return this;
        }

        public Animator easing(Easing ... easing) {
            this.easing = easing.length < 1 ? DEFAULT_EASING : easing;
            return this;
        }

        public Animator linear() {
            return this.easing(Easing.linear);
        }

        public Animator ease() {
            return this.easing(Easing.ease);
        }

        public Animator easeIn() {
            return this.easing(Easing.easeIn);
        }

        public Animator easeOut() {
            return this.easing(Easing.easeOut);
        }

        public Animator easeInOut() {
            return this.easing(Easing.easeInOut);
        }

        public Animator stop() {
            this.index = 0;
            this.animating = false;
            return this;
        }

        public boolean isAnimating() {
            return this.animating;
        }

        public Animator whenDone(Consumer<Property> whenDoneConsumer) {
            this.onDoneConsumer = whenDoneConsumer;
            if (!this.animating) {
                this.onDoneConsumer.accept(this.property);
            }
            return this;
        }

        private void tick() {
            if (!this.animating) {
                assert (false);
                return;
            }
            try {
                long currentTime = this.property.graph.nanos();
                double toValue = this.to[this.index];
                long duration = this.in[this.index % this.in.length];
                double proportion = duration < 1L ? 1.0 : (double)(currentTime - this.fromTime) / (double)duration;
                if (proportion >= 1.0) {
                    ++this.index;
                    if (this.index >= this.to.length) {
                        this.finish(currentTime - (this.fromTime + duration));
                    } else {
                        this.fromValue = toValue;
                        this.fromTime += duration;
                    }
                    this.property.setImpl(toValue);
                } else if (proportion > 0.0) {
                    Easing ease = this.easing[this.index % this.easing.length];
                    double d = ease.calculate(proportion);
                    d = d * (toValue - this.fromValue) + this.fromValue;
                    this.property.setImpl(d);
                }
            }
            catch (Exception exception) {
                this.finish(0L);
            }
        }

        private void finish(long overrun) {
            this.index = 0;
            this.animating = false;
            this.overrun = overrun;
            if (this.onDoneConsumer != null) {
                this.onDoneConsumer.accept(this.property);
            }
            this.overrun = 0L;
        }
    }

    private class Link
    implements Linkable.Double {
        private DoubleConsumer consumer;

        private Link() {
        }

        @Override
        public void link(DoubleConsumer consumer) {
            if (this.consumer != null) {
                throw new IllegalStateException("Cannot link multiple consumers in one chain");
            }
            this.consumer = Objects.requireNonNull(consumer);
            this.fire(Property.this.get());
            Property.this.links.add(this);
        }

        private void fire(double value) {
            this.consumer.accept(value);
        }
    }
}

