/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import org.jaudiolibs.pipes.graph.AbstractLinkable;

public interface Linkable<T> {
    public void link(Consumer<T> var1);

    default public <R> Linkable<R> map(final Function<? super T, ? extends R> function) {
        return new AbstractLinkable<T, R>(this){

            @Override
            void process(T value, Consumer<R> sink) {
                sink.accept(function.apply(value));
            }
        };
    }

    default public Linkable<T> filter(final Predicate<? super T> predicate) {
        return new AbstractLinkable<T, T>(this){

            @Override
            void process(T value, Consumer<T> sink) {
                if (predicate.test(value)) {
                    sink.accept(value);
                }
            }
        };
    }

    public static interface Int {
        public void link(IntConsumer var1);

        default public Int map(final IntUnaryOperator function) {
            return new AbstractLinkable.Int(this){

                @Override
                void process(int value, IntConsumer sink) {
                    sink.accept(function.applyAsInt(value));
                }
            };
        }

        default public <R> Linkable<R> mapTo(final IntFunction<? extends R> function) {
            return new AbstractLinkable.IntToObj<R>(this){

                @Override
                void process(int value, Consumer<R> sink) {
                    sink.accept(function.apply(value));
                }
            };
        }

        default public Int filter(final IntPredicate predicate) {
            return new AbstractLinkable.Int(this){

                @Override
                void process(int value, IntConsumer sink) {
                    if (predicate.test(value)) {
                        sink.accept(value);
                    }
                }
            };
        }
    }

    public static interface Double {
        public void link(DoubleConsumer var1);

        default public Double map(final DoubleUnaryOperator function) {
            return new AbstractLinkable.Double(this){

                @Override
                void process(double value, DoubleConsumer sink) {
                    sink.accept(function.applyAsDouble(value));
                }
            };
        }

        default public <R> Linkable<R> mapTo(final DoubleFunction<? extends R> function) {
            return new AbstractLinkable.DoubleToObj<R>(this){

                @Override
                void process(double value, Consumer<R> sink) {
                    sink.accept(function.apply(value));
                }
            };
        }

        default public Double filter(final DoublePredicate predicate) {
            return new AbstractLinkable.Double(this){

                @Override
                void process(double value, DoubleConsumer sink) {
                    if (predicate.test(value)) {
                        sink.accept(value);
                    }
                }
            };
        }
    }
}

