/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiolibs.audioservers.AudioClient;
import org.jaudiolibs.audioservers.AudioConfiguration;
import org.jaudiolibs.audioservers.AudioServer;
import org.jaudiolibs.audioservers.AudioServerProvider;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.client.PipesAudioClient;
import org.jaudiolibs.pipes.graph.Graph;
import org.jaudiolibs.pipes.graph.Inject;
import org.jaudiolibs.pipes.graph.UGen;

public class GraphPlayer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(GraphPlayer.class.getName());
    private static final float DEFAULT_SAMPLERATE = 48000.0f;
    private static final int DEFAULT_BUFFERSIZE = 1024;
    private static final int DEFAULT_BLOCKSIZE = 64;
    private static final String DEFAULT_LIB = "JavaSound";
    private final Graph graph;
    private final String libName;
    private final float sampleRate;
    private final int bufferSize;
    private final int blockSize;
    private final AudioConfiguration config;
    private final PipesAudioClient client;
    private final AtomicReference<AudioServer> server;

    private GraphPlayer(Builder init) {
        this.graph = init.graph;
        this.libName = init.libName;
        this.sampleRate = init.sampleRate;
        this.bufferSize = init.bufferSize;
        this.blockSize = init.blockSize;
        this.config = new AudioConfiguration(this.sampleRate, this.graph.inputs.length, this.graph.outputs.length, this.bufferSize, new Object[0]);
        this.client = new PipesAudioClient(this.blockSize, this.graph.inputs.length, this.graph.outputs.length);
        this.client.addListener((PipesAudioClient.Listener)new ClientListener());
        this.server = new AtomicReference();
    }

    @Override
    public void run() {
        try {
            if (!this.server.compareAndSet(null, this.createServer())) {
                throw new IllegalStateException("GraphPlayer already started");
            }
            this.server.get().run();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception thrown running graph", ex);
        }
    }

    public void start() {
        Thread t = new Thread(this);
        t.setPriority(10);
        t.start();
    }

    public void shutdown() {
        this.server.get().shutdown();
    }

    private AudioServer createServer() throws Exception {
        AudioServerProvider p;
        AudioServerProvider provider = null;
        String lib = this.libName.isEmpty() ? DEFAULT_LIB : this.libName;
        Iterator<AudioServerProvider> iterator = ServiceLoader.load(AudioServerProvider.class).iterator();
        while (iterator.hasNext()) {
            p = iterator.next();
            if (!lib.equals(p.getLibraryName())) continue;
            provider = p;
            break;
        }
        if (provider == null && this.libName.isEmpty() && (iterator = ServiceLoader.load(AudioServerProvider.class).iterator()).hasNext()) {
            provider = p = iterator.next();
        }
        if (provider == null) {
            throw new IllegalStateException("No AudioServer found that matches : " + lib);
        }
        return provider.createServer(this.config, (AudioClient)this.client);
    }

    private void handleConfigure(AudioConfiguration context) throws Exception {
        try {
            this.graph.blockSize = this.blockSize;
            this.graph.sampleRate = context.getSampleRate();
            this.connectIO();
            this.handleInjection();
            this.graph.handleInit();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception thrown configuring graph", ex);
            throw ex;
        }
    }

    private void handleProcess() {
        this.graph.handleUpdate();
    }

    private void connectIO() {
        int i;
        for (i = 0; i < this.graph.inputs.length; ++i) {
            this.graph.inputs[i].addSource(this.client.getSource(i));
        }
        for (i = 0; i < this.graph.outputs.length; ++i) {
            this.client.getSink(i).addSource(this.graph.outputs[i]);
        }
    }

    private void handleInjection() throws Exception {
        for (Field field : this.graph.getClass().getDeclaredFields()) {
            if (Pipe.class.isAssignableFrom(field.getType()) && (field.isAnnotationPresent(UGen.class) || field.isAnnotationPresent(Inject.class))) {
                this.injectUnit(field, field.getType());
                continue;
            }
            if (!Graph.Dependent.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(Inject.class)) continue;
            this.injectDependent(field, field.getType());
        }
    }

    private void injectUnit(Field field, Class<?> unitClass) throws Exception {
        field.setAccessible(true);
        field.set(this.graph, unitClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private void injectDependent(Field field, Class<?> depClass) throws Exception {
        field.setAccessible(true);
        Graph.Dependent dep = (Graph.Dependent)depClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.graph.addDependent(dep);
        field.set(this.graph, dep);
    }

    public static Builder create(Graph graph) {
        return new Builder(graph);
    }

    public static class Builder {
        private final Graph graph;
        private String libName = "";
        private float sampleRate = 48000.0f;
        private int bufferSize = 1024;
        private int blockSize = 64;

        private Builder(Graph graph) {
            this.graph = graph;
        }

        public Builder library(String libName) {
            this.libName = Objects.requireNonNull(libName);
            return this;
        }

        public Builder sampleRate(float sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public GraphPlayer build() {
            return new GraphPlayer(this);
        }
    }

    private class ClientListener
    implements PipesAudioClient.Listener {
        private ClientListener() {
        }

        public void configure(AudioConfiguration context) throws Exception {
            GraphPlayer.this.handleConfigure(context);
        }

        public void process() {
            GraphPlayer.this.handleProcess();
        }
    }
}

