/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import org.jaudiolibs.pipes.Add;
import org.jaudiolibs.pipes.Pipe;
import org.jaudiolibs.pipes.Tee;
import org.jaudiolibs.pipes.graph.NoteUtils;
import org.jaudiolibs.pipes.units.AudioTable;
import org.jaudiolibs.pipes.units.Fn;
import org.jaudiolibs.pipes.units.Mod;

public abstract class Graph {
    final Pipe[] inputs;
    final Pipe[] outputs;
    final List<Dependent> dependents;
    final Scheduler scheduler;
    double sampleRate;
    int blockSize;
    long samplePosition;

    protected Graph() {
        this(2, 2);
    }

    protected Graph(int inputCount, int outputCount) {
        int i;
        this.inputs = new Pipe[inputCount];
        this.outputs = new Pipe[outputCount];
        for (i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new Tee();
        }
        for (i = 0; i < this.outputs.length; ++i) {
            this.outputs[i] = new Add();
        }
        this.dependents = new CopyOnWriteArrayList<Dependent>();
        this.scheduler = new Scheduler(this);
        this.dependents.add(this.scheduler);
    }

    void handleInit() {
        this.samplePosition = -this.blockSize;
        this.init();
    }

    void handleUpdate() {
        this.samplePosition += (long)this.blockSize;
        if (this.samplePosition < 0L) {
            this.samplePosition = 0L;
        }
        this.dependents.forEach(Dependent::update);
        this.update();
    }

    protected abstract void init();

    protected void update() {
    }

    public long position() {
        return this.samplePosition;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public double sampleRate() {
        return this.sampleRate;
    }

    public long millis() {
        return (long)((double)this.samplePosition / this.sampleRate * 1000.0);
    }

    public long nanos() {
        return (long)((double)this.samplePosition / this.sampleRate * 1.0E9);
    }

    public void invokeLater(Runnable task) {
        this.scheduler.execute(task);
    }

    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    protected void addDependent(Dependent dependent) {
        this.dependents.add(Objects.requireNonNull(dependent));
        dependent.attach(this);
    }

    protected void removeDependent(Dependent dependent) {
        this.dependents.remove(dependent);
        dependent.detach(this);
    }

    protected final Pipe in(int index) {
        return this.inputs[index];
    }

    protected final Pipe out(int index) {
        return this.outputs[index];
    }

    protected final Pipe link(Pipe ... ugens) {
        int count = ugens.length;
        if (count < 1) {
            return null;
        }
        for (int i = ugens.length - 1; i > 0; --i) {
            ugens[i].addSource(ugens[i - 1]);
        }
        return ugens[ugens.length - 1];
    }

    protected final Add add() {
        return new Add();
    }

    protected final Add add(Pipe ... ugens) {
        Add add = new Add();
        for (Pipe ugen : ugens) {
            add.addSource(ugen);
        }
        return add;
    }

    protected final Mod mod() {
        return new Mod();
    }

    protected final Mod mod(Pipe ... ugens) {
        Mod mod = new Mod();
        for (Pipe ugen : ugens) {
            mod.addSource(ugen);
        }
        return mod;
    }

    protected final Mod modFn(DoubleBinaryOperator function) {
        Mod mod = new Mod();
        mod.function(function);
        return mod;
    }

    protected final Mod modFn(Pipe pipe, DoubleBinaryOperator function) {
        Mod mod = this.modFn(function);
        mod.addSource(pipe);
        return mod;
    }

    protected final Tee tee() {
        return new Tee();
    }

    protected final Fn fn(DoubleUnaryOperator function) {
        return new Fn(function);
    }

    protected final double noteToFrequency(String note) {
        int midi = this.noteToMidi(note);
        if (midi < 0) {
            return 0.0;
        }
        return this.midiToFrequency(midi);
    }

    protected final int noteToMidi(String note) {
        return NoteUtils.noteToMidi(note);
    }

    protected final double midiToFrequency(int midi) {
        return NoteUtils.midiToFrequency(midi);
    }

    protected double tabread(AudioTable table, double position) {
        return table == null ? 0.0 : table.get(0, position * (double)table.size());
    }

    private static class Scheduler
    extends AbstractExecutorService
    implements ScheduledExecutorService,
    Dependent {
        private final Graph graph;
        private final ConcurrentLinkedQueue<Runnable> queue;
        private final DelayQueue<ScheduledFutureTask<?>> delayQueue;
        private long time;

        private Scheduler(Graph graph) {
            this.graph = graph;
            this.queue = new ConcurrentLinkedQueue();
            this.delayQueue = new DelayQueue();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void execute(Runnable command) {
            this.queue.offer(command);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, unit.toNanos(delay), 0L);
            this.queue.offer(task);
            return task;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            ScheduledFutureTask<V> task = new ScheduledFutureTask<V>(callable, unit.toNanos(delay), 0L);
            this.queue.offer(task);
            return task;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            ScheduledFutureTask<Object> task = new ScheduledFutureTask<Object>(command, null, unit.toNanos(initialDelay), unit.toNanos(period));
            this.queue.offer(task);
            return task;
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
        }

        @Override
        public void update() {
            Runnable r;
            this.time = this.graph.nanos();
            while ((r = this.queue.poll()) != null) {
                if (r instanceof ScheduledFutureTask) {
                    ScheduledFutureTask task = (ScheduledFutureTask)r;
                    task.time = this.time + task.delay;
                    this.delayQueue.offer(task);
                    continue;
                }
                r.run();
            }
            while ((r = (Runnable)this.delayQueue.poll()) != null) {
                r.run();
            }
        }

        private class ScheduledFutureTask<T>
        extends FutureTask<T>
        implements RunnableScheduledFuture<T> {
            private final long delay;
            private final long period;
            private long time;

            ScheduledFutureTask(Runnable runnable, T result, long delay, long period) {
                super(runnable, result);
                this.delay = delay;
                this.period = period;
            }

            ScheduledFutureTask(Callable<T> callable, long delay, long period) {
                super(callable);
                this.delay = delay;
                this.period = period;
            }

            @Override
            public boolean isPeriodic() {
                return this.period > 0L;
            }

            @Override
            public void run() {
                if (this.isPeriodic()) {
                    if (this.runAndReset()) {
                        this.time += this.period;
                        Scheduler.this.delayQueue.offer(this);
                    }
                } else {
                    super.run();
                }
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return unit.convert(this.time - Scheduler.this.graph.nanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public int compareTo(Delayed other) {
                if (other == this) {
                    return 0;
                }
                if (other instanceof ScheduledFuture) {
                    ScheduledFutureTask o = (ScheduledFutureTask)other;
                    long diff = this.time - o.time;
                    return diff < 0L ? -1 : 1;
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface Dependent {
        default public void attach(Graph graph) {
        }

        default public void detach(Graph graph) {
        }

        public void update();
    }
}

