/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.IntConsumer;
import org.jaudiolibs.pipes.graph.Graph;
import org.jaudiolibs.pipes.graph.Linkable;

public final class Clock
implements Graph.Dependent {
    private final List<Link> links = new CopyOnWriteArrayList<Link>();
    private Graph graph;
    private int index;
    private int maxIndex = Integer.MAX_VALUE;
    private double bpm = 120.0;
    private int subdivision = 4;
    private int bufferCount;
    private int position;

    @Override
    public void attach(Graph graph) {
        this.graph = graph;
        this.updatePulse();
    }

    @Override
    public void update() {
        if (this.position++ == 0) {
            this.fire();
        }
        this.position %= this.bufferCount;
    }

    public Clock bpm(double bpm) {
        this.bpm = bpm;
        this.updatePulse();
        return this;
    }

    public double bpm() {
        return this.bpm;
    }

    public Clock subdivision(int subdivision) {
        this.subdivision = subdivision;
        this.updatePulse();
        return this;
    }

    public int subdivision() {
        return this.subdivision;
    }

    public Clock clearLinks() {
        this.links.clear();
        return this;
    }

    public Clock link(Runnable runnable) {
        Link l = new Link();
        l.link((int i) -> runnable.run());
        return this;
    }

    public Linkable.Int on() {
        return new Link();
    }

    public Clock index(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException("Index cannot be less than zero");
        }
        this.index = idx % this.maxIndex;
        return this;
    }

    public Clock maxIndex(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Max index must be greater than 0");
        }
        this.maxIndex = max;
        this.index %= this.maxIndex;
        return this;
    }

    public int index() {
        return this.index;
    }

    public int maxIndex() {
        return this.maxIndex;
    }

    private void fire() {
        this.fireLinks();
        this.incrementIndex();
    }

    private void fireLinks() {
        this.links.forEach(l -> ((Link)l).fire(this.index));
    }

    private void incrementIndex() {
        this.index = (this.index + 1) % this.maxIndex;
    }

    void updatePulse() {
        if (this.graph == null) {
            return;
        }
        double secPerPulse = 1.0 / (this.bpm * (double)this.subdivision / 60.0);
        double bufPerPulse = secPerPulse / ((double)this.graph.blockSize() / this.graph.sampleRate());
        this.bufferCount = (int)(bufPerPulse + 0.5);
    }

    private class Link
    implements Linkable.Int {
        private IntConsumer consumer;

        private Link() {
        }

        @Override
        public void link(IntConsumer consumer) {
            if (this.consumer != null) {
                throw new IllegalStateException("Cannot link multiple consumers in one chain");
            }
            this.consumer = Objects.requireNonNull(consumer);
            Clock.this.links.add(this);
        }

        private void fire(int value) {
            this.consumer.accept(value);
        }
    }
}

