/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiolibs.pipes.graph;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import org.jaudiolibs.pipes.graph.Linkable;

abstract class AbstractLinkable<IN, OUT>
implements Consumer<IN>,
Linkable<OUT> {
    private final Linkable<IN> source;
    private Consumer<OUT> sink;

    AbstractLinkable(Linkable<IN> source) {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public void accept(IN value) {
        this.process(value, this.sink);
    }

    @Override
    public void link(Consumer<OUT> consumer) {
        this.sink = Objects.requireNonNull(consumer);
        this.source.link(this);
    }

    abstract void process(IN var1, Consumer<OUT> var2);

    static abstract class IntToObj<OUT>
    implements IntConsumer,
    Linkable<OUT> {
        private final Linkable.Int source;
        private Consumer<OUT> sink;

        IntToObj(Linkable.Int source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(int value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(Consumer<OUT> consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(int var1, Consumer<OUT> var2);
    }

    static abstract class Int
    implements IntConsumer,
    Linkable.Int {
        private final Linkable.Int source;
        private IntConsumer sink;

        Int(Linkable.Int source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(int value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(IntConsumer consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(int var1, IntConsumer var2);
    }

    static abstract class DoubleToObj<OUT>
    implements DoubleConsumer,
    Linkable<OUT> {
        private final Linkable.Double source;
        private Consumer<OUT> sink;

        DoubleToObj(Linkable.Double source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(double value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(Consumer<OUT> consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(double var1, Consumer<OUT> var3);
    }

    static abstract class Double
    implements DoubleConsumer,
    Linkable.Double {
        private final Linkable.Double source;
        private DoubleConsumer sink;

        Double(Linkable.Double source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(double value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(DoubleConsumer consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(double var1, DoubleConsumer var3);
    }

    static abstract class ToInt<IN>
    implements Consumer<IN>,
    Linkable.Int {
        private final Linkable<IN> source;
        private IntConsumer sink;

        ToInt(Linkable<IN> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(IN value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(IntConsumer consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(IN var1, IntConsumer var2);
    }

    static abstract class ToDouble<IN>
    implements Consumer<IN>,
    Linkable.Double {
        private final Linkable<IN> source;
        private DoubleConsumer sink;

        ToDouble(Linkable<IN> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void accept(IN value) {
            this.process(value, this.sink);
        }

        @Override
        public void link(DoubleConsumer consumer) {
            this.sink = Objects.requireNonNull(consumer);
            this.source.link(this);
        }

        abstract void process(IN var1, DoubleConsumer var2);
    }
}

