/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Authenticator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.BaseCredentialsAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.SimplePasswordAuthenticator;

public class CachedPasswordAuthenticationService
extends BaseCredentialsAuthenticationService {
    private static final String KEY = "cachedPassword";
    public static final String USERNAME_ATTRIBUTE = "user.login.id";
    public static final String PASSWORD_ATTRIBUTE = "password";

    public CachedPasswordAuthenticationService() {
        HashMap<String, ConfigurationParameter> m = new HashMap<String, ConfigurationParameter>();
        for (ConfigurationParameter param : this.getAdminConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        for (ConfigurationParameter param : this.getUserConfigurationParameters()) {
            m.put(param.getKey(), param);
        }
        this.setConfigParams(Collections.unmodifiableMap(m));
    }

    @Override
    public boolean isConfigured(PortletRequest req, MailStoreConfiguration config) {
        String mailAccount = this.getMailAccountName(req, config);
        String password = this.getPassword(req);
        return mailAccount != null && password != null;
    }

    @Override
    public Authenticator getAuthenticator(PortletRequest req, MailStoreConfiguration config) {
        return new SimplePasswordAuthenticator(this.getMailAccountName(req, config), this.getPassword(req));
    }

    @Override
    public Credentials getCredentials(PortletRequest req, MailStoreConfiguration config) {
        String ntlmDomain = config.getExchangeDomain();
        if (StringUtils.isNotBlank((String)ntlmDomain)) {
            String username = this.getMailAccountName(req, config);
            return this.createNTCredentials(ntlmDomain, username, this.getPassword(req));
        }
        return new UsernamePasswordCredentials(this.getMailAccountName(req, config), this.getPassword(req));
    }

    @Override
    public String getMailAccountName(PortletRequest request, MailStoreConfiguration config) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String accountName = (String)userInfo.get(USERNAME_ATTRIBUTE);
        return this.createMailAccountName(accountName, config);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    private String getPassword(PortletRequest req) {
        Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
        return (String)userInfo.get(PASSWORD_ATTRIBUTE);
    }
}

