/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.service.auth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.service.ConfigurationParameter;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;

public abstract class BaseCredentialsAuthenticationService
implements IAuthenticationService {
    protected List<ConfigurationParameter> userParameters = Collections.emptyList();
    protected List<ConfigurationParameter> adminParameters = Collections.emptyList();
    protected Map<String, ConfigurationParameter> configParams = Collections.emptyMap();

    @Override
    public Map<String, ConfigurationParameter> getConfigurationParametersMap() {
        return this.configParams;
    }

    @Override
    public List<ConfigurationParameter> getAdminConfigurationParameters() {
        return this.adminParameters;
    }

    @Override
    public List<ConfigurationParameter> getUserConfigurationParameters() {
        return this.userParameters;
    }

    protected void setUserParameters(List<ConfigurationParameter> params) {
        this.userParameters = params;
    }

    protected void setAdminParameters(List<ConfigurationParameter> params) {
        this.adminParameters = params;
    }

    protected void setConfigParams(Map<String, ConfigurationParameter> params) {
        this.configParams = params;
    }

    protected String createMailAccountName(String accountName, MailStoreConfiguration config) {
        String suffix = config.getUsernameSuffix();
        if (accountName != null && StringUtils.isNotBlank((String)suffix)) {
            return accountName.concat(suffix);
        }
        return accountName;
    }

    protected Credentials createNTCredentials(String ntlmDomain, String username, String password) {
        int index = username.indexOf("@");
        username = index > 0 ? username.substring(0, index) : username;
        return new NTCredentials(username, password, "paramDoesNotSeemToMatter", ntlmDomain);
    }
}

