/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.processor;

import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.processor.IContentProcessor;
import org.joda.time.Interval;

public class RssContentProcessorImpl
implements IContentProcessor<SyndFeed> {
    protected final Log log = LogFactory.getLog(this.getClass());

    public SyndFeed getIntermediateCalendar(Interval interval, InputStream in) {
        try {
            SyndFeedInput input = new SyndFeedInput();
            InputStreamReader reader = new InputStreamReader(in);
            SyndFeed feed = input.build((Reader)reader);
            return feed;
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FeedException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public Set<VEvent> getEvents(Interval interval, SyndFeed feed) {
        HashSet<VEvent> events = new HashSet<VEvent>();
        try {
            List entries = feed.getEntries();
            for (SyndEntry entry : entries) {
                PropertyList props = new PropertyList();
                java.util.Date start = null;
                if (entry.getPublishedDate() != null) {
                    start = entry.getPublishedDate();
                }
                if (start == null || !interval.contains(start.getTime())) continue;
                props.add((Property)new DtStart((Date)new DateTime(start), true));
                props.add((Property)new Summary(entry.getTitle()));
                props.add((Property)new Description(entry.getDescription().getValue()));
                String guid = null;
                if (entry instanceof Item && ((Item)entry).getGuid() != null) {
                    guid = ((Item)entry).getGuid().getValue();
                    props.add((Property)new Uid(guid));
                }
                if (entry.getLink() != null) {
                    try {
                        props.add((Property)new Url(new URI(entry.getLink())));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                VEvent event = new VEvent(props);
                events.add(event);
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return events;
    }
}

