/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.credentials;

import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.credentials.ICredentialsExtractor;

public final class RequestAttributeCredentialsExtractorImpl
implements ICredentialsExtractor {
    private final Log log = LogFactory.getLog(this.getClass());
    private String usernameAttribute = "username";
    private String passwordAttribute = "password";

    public RequestAttributeCredentialsExtractorImpl() {
    }

    public RequestAttributeCredentialsExtractorImpl(String passwordAttribute, String usernameAttribute) {
        this.passwordAttribute = passwordAttribute;
        this.usernameAttribute = usernameAttribute;
    }

    @Override
    public Credentials getCredentials(PortletRequest request) {
        String password;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String username = (String)userInfo.get(this.usernameAttribute);
        if (StringUtils.isBlank((String)username)) {
            this.log.warn((Object)("No username found in the USER_INFO map on the PortletRequest;  attribute name was:  " + this.usernameAttribute));
        }
        if (StringUtils.isBlank((String)(password = (String)userInfo.get(this.passwordAttribute)))) {
            this.log.warn((Object)("No password found in the USER_INFO map on the PortletRequest;  attribute name was:  " + this.passwordAttribute));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }
}

