/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.exchange.IExchangeCredentialsInitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public class ExchangeCredentialsInitializationService
implements IExchangeCredentialsInitializationService {
    public static final String PREFS_NTDOMAIN = "exchangeNtlmDomain";
    public static final String PREFS_IMPERSONATION_USERNAME = "exchangeImpersonationUsername";
    public static final String PREFS_IMPERSONATION_PASSWORD = "exchangeImpersonationPassword";
    @Value(value="${ExchangeCredentialsInitializationService.enabled:false}")
    private boolean enabled;
    @Value(value="${ExchangeCredentialsInitializationService.exchangeImpersonationUsername:}")
    private String exchangeImpersonationUsername;
    @Value(value="${ExchangeCredentialsInitializationService.exchangeImpersonationPassword:}")
    private String exchangeImpersonationPassword;
    private String usernameAttribute = "user.login.id";
    private String passwordAttribute = "password";
    private String mailAttribute = "mail";
    private String ntlmDomain = null;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public void setMailAttribute(String mailAttribute) {
        this.mailAttribute = mailAttribute;
    }

    public String getNtlmDomain(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        String ntlmDomain = prefs.getValue(PREFS_NTDOMAIN, "");
        return StringUtils.isBlank((String)ntlmDomain) ? this.ntlmDomain : ntlmDomain;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    public void initialize(PortletRequest request) {
        this.logger.debug("{} is {}", (Object)this.getClass().getSimpleName(), (Object)(this.enabled ? "ENABLED" : "DISABLED"));
        if (this.enabled) {
            NTCredentials credentials;
            if (this.usesExchangeImpersonation(request)) {
                String exchangeImpersonationUsername = this.evaluateExchangeImpersonationUsername(request);
                String exchangeImpersonationPassword = this.evaluateExchangeImpersonationPassword(request);
                credentials = new NTCredentials(exchangeImpersonationUsername, exchangeImpersonationPassword, "paramDoesNotSeemToMatter", "");
                this.logger.debug("Created Exchange Impersonation credentials for EWS call; exchangeImpersonationUsername='{}', exchangeImpersonationPassword.length={}", (Object)exchangeImpersonationUsername, (Object)exchangeImpersonationPassword.length());
            } else {
                Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
                String password = (String)userInfo.get(this.passwordAttribute);
                if (password == null) {
                    throw new CalendarException("Required user attribute password is null. Insure user-attribute password is enabled in portlet.xml and CAS ClearPass is configured properly");
                }
                String ntDomain = this.getNtlmDomain(request);
                if (StringUtils.isNotBlank((String)ntDomain)) {
                    String username = (String)userInfo.get(this.usernameAttribute);
                    credentials = this.createNTCredentials(ntDomain, username, password);
                    this.logger.debug("Creating NT credentials for {}", (Object)username);
                } else {
                    String emailAddress = (String)userInfo.get(this.mailAttribute);
                    if (emailAddress == null) {
                        throw new CalendarException("Required user attribute email address is null. Insure user-attribute mail is enabled in portlet.xml and populated via LDAP or other approach");
                    }
                    credentials = new UsernamePasswordCredentials(emailAddress, password);
                    this.logger.debug("Creating simple username/password credentials for {}", (Object)emailAddress);
                }
            }
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null) {
                requestAttributes = new PortletRequestAttributes(request);
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            }
            requestAttributes.setAttribute("exchangeCredentials", (Object)credentials, 1);
        }
    }

    public boolean usesExchangeImpersonation(PortletRequest request) {
        String exchangeImpersonationUsername = this.evaluateExchangeImpersonationUsername(request);
        String exchangeImpersonationPassword = this.evaluateExchangeImpersonationPassword(request);
        if (StringUtils.isBlank((String)exchangeImpersonationUsername) != StringUtils.isBlank((String)exchangeImpersonationPassword)) {
            this.logger.error("Both {} and {} must be set if using Exchange Web Services (EWS) Impersonation, or both must be blank if not using EWS Impersonation", (Object)PREFS_IMPERSONATION_USERNAME, (Object)PREFS_IMPERSONATION_PASSWORD);
        }
        return StringUtils.isNotBlank((String)exchangeImpersonationUsername) && StringUtils.isNotBlank((String)exchangeImpersonationPassword);
    }

    public String getImpersonatedAccountId(PortletRequest request) {
        if (this.usesExchangeImpersonation(request)) {
            Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
            String username = (String)userInfo.get(this.usernameAttribute);
            String domainName = this.getNtlmDomain(request);
            if (StringUtils.isBlank((String)username)) {
                throw new CalendarException("Null Username obtained from user attribute " + this.usernameAttribute + ". It must be non-null when using Exchange Impersonation");
            }
            if (StringUtils.isBlank((String)domainName)) {
                throw new CalendarException("Domain name must be specified in properties file or portlet  preferences when using Exchange Impersonation");
            }
            String impersonatedId = username + "@" + domainName;
            this.logger.debug("Returning Impersonated ID {}", (Object)impersonatedId);
            return impersonatedId;
        }
        return null;
    }

    protected Credentials createNTCredentials(String ntlmDomain, String username, String password) {
        if (username == null) {
            throw new CalendarException("Required user attribute username is null. Insure user-attribute user.login.id is present in the <user-attribute> section of portlet.xml");
        }
        int index = username.indexOf("@");
        username = index > 0 ? username.substring(0, index) : username;
        return new NTCredentials(username, password, "paramDoesNotSeemToMatter", ntlmDomain);
    }

    private String evaluateExchangeImpersonationUsername(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String rslt = prefs.getValue(PREFS_IMPERSONATION_USERNAME, "");
        if (StringUtils.isBlank((String)rslt) && StringUtils.isNotBlank((String)this.exchangeImpersonationUsername)) {
            rslt = this.exchangeImpersonationUsername;
        }
        return rslt;
    }

    private String evaluateExchangeImpersonationPassword(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String rslt = prefs.getValue(PREFS_IMPERSONATION_PASSWORD, "");
        if (StringUtils.isBlank((String)rslt) && StringUtils.isNotBlank((String)this.exchangeImpersonationPassword)) {
            rslt = this.exchangeImpersonationPassword;
        }
        return rslt;
    }
}

