/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.dao;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarDefinition;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.springframework.beans.factory.annotation.Required;

public final class PortletPreferencesCalendarSetDao
implements ICalendarSetDao {
    private static final String CALENDAR_FNAME_KEY = "calendarFnames";
    private static final String CALENDAR_SET_KEY = "PortletPreferencesCalendarSetDao.CALENDAR_SET_KEY";
    private CalendarStore calendarStore;
    private final Log log = LogFactory.getLog(this.getClass());

    @Resource(name="calendarStore")
    @Required
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public CalendarSet<CalendarConfiguration> getCalendarSet(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        CalendarSet<CalendarConfiguration> rslt = (CalendarSet<CalendarConfiguration>)session.getAttribute(CALENDAR_SET_KEY);
        if (rslt == null) {
            rslt = this.createCalendarSet(request);
            session.setAttribute(CALENDAR_SET_KEY, rslt);
        }
        return rslt;
    }

    @Override
    public List<PredefinedCalendarConfiguration> getAvailablePredefinedCalendarConfigurations(PortletRequest request) {
        return Collections.emptyList();
    }

    private CalendarSet<CalendarConfiguration> createCalendarSet(PortletRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Evaluating CalendarSet for user:  " + request.getRemoteUser()));
        }
        PortletPreferences preferences = request.getPreferences();
        String[] calendarFnames = preferences.getValues(CALENDAR_FNAME_KEY, new String[0]);
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Found the following calendarFnames in PortletPreferences:  ");
            for (String fName : calendarFnames) {
                msg.append(fName).append(" ");
            }
            this.log.debug((Object)msg.toString());
        }
        HashSet<PredefinedCalendarConfiguration> calendars = new HashSet<PredefinedCalendarConfiguration>();
        long nextId = 0L;
        for (String fname : calendarFnames) {
            CalendarDefinition definition = null;
            try {
                definition = this.calendarStore.getCalendarDefinition(fname);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to retrieve calendar definition with fname " + fname));
            }
            if (definition == null) continue;
            PredefinedCalendarConfiguration config = new PredefinedCalendarConfiguration();
            config.setId(++nextId);
            config.setCalendarDefinition(definition);
            calendars.add(config);
        }
        CalendarSet<CalendarConfiguration> set = new CalendarSet<CalendarConfiguration>(calendars);
        return set;
    }
}

