/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.PredefinedCalendarDefinition;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;

public class WhitelistFilteringCalendarSetDao
implements ICalendarSetDao {
    private ICalendarSetDao enclosedCalendarSetDao;
    private static final String CALENDAR_WHITELIST_PREFERENCE = "calendarWhitelist";

    public void setEnclosedCalendarSetDao(ICalendarSetDao enclosedCalendarSetDao) {
        this.enclosedCalendarSetDao = enclosedCalendarSetDao;
    }

    public CalendarSet<?> getCalendarSet(PortletRequest req) {
        CalendarSet unmodifiedSet = this.enclosedCalendarSetDao.getCalendarSet(req);
        List whitelist = this.getWhitelist(req);
        if (whitelist.size() == 0) {
            return unmodifiedSet;
        }
        HashSet<CalendarConfiguration> configurations = new HashSet<CalendarConfiguration>();
        Set rawSet = unmodifiedSet.getConfigurations();
        for (CalendarConfiguration config : rawSet) {
            if (config.getCalendarDefinition() instanceof PredefinedCalendarDefinition) {
                PredefinedCalendarDefinition pdef = (PredefinedCalendarDefinition)config.getCalendarDefinition();
                if (!whitelist.contains(pdef.getFname())) continue;
                configurations.add(config);
                continue;
            }
            configurations.add(config);
        }
        return new CalendarSet(configurations);
    }

    public List<PredefinedCalendarConfiguration> getAvailablePredefinedCalendarConfigurations(PortletRequest req) {
        List unmodifiedList = this.enclosedCalendarSetDao.getAvailablePredefinedCalendarConfigurations(req);
        List whitelist = this.getWhitelist(req);
        if (whitelist.size() == 0) {
            return unmodifiedList;
        }
        ArrayList<PredefinedCalendarConfiguration> rslt = new ArrayList<PredefinedCalendarConfiguration>();
        for (PredefinedCalendarConfiguration config : unmodifiedList) {
            PredefinedCalendarDefinition pdef = (PredefinedCalendarDefinition)config.getCalendarDefinition();
            if (!whitelist.contains(pdef.getFname())) continue;
            rslt.add(config);
        }
        return rslt;
    }

    private List<String> getWhitelist(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] prefValues = prefs.getValues(CALENDAR_WHITELIST_PREFERENCE, new String[0]);
        ArrayList<String> whitelist = new ArrayList<String>();
        for (String fname : prefValues) {
            String trimFname = fname.trim();
            if (trimFname.isEmpty()) continue;
            whitelist.add(trimFname);
        }
        return whitelist;
    }
}

