/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.RRule;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.jasig.portlet.calendar.credentials.DefaultCredentialsExtractorImpl;
import org.jasig.portlet.calendar.credentials.ICredentialsExtractor;
import org.jasig.portlet.calendar.url.DefaultUrlCreatorImpl;
import org.jasig.portlet.calendar.url.IUrlCreator;
import org.osaf.caldav4j.CalDAV4JException;
import org.osaf.caldav4j.CalDAVCalendarCollection;
import org.osaf.caldav4j.methods.CalDAV4JMethodFactory;
import org.osaf.caldav4j.methods.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalDavCalendarAdapter
implements ICalendarAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private IUrlCreator urlCreator = new DefaultUrlCreatorImpl();
    private ICredentialsExtractor credentialsExtractor = new DefaultCredentialsExtractorImpl();
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "default";

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setUrlCreator(IUrlCreator urlCreator) {
        this.urlCreator = urlCreator;
    }

    public void setCredentialsExtractor(ICredentialsExtractor credentialsExtractor) {
        this.credentialsExtractor = credentialsExtractor;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, PortletRequest request) throws CalendarException {
        HashSet<CalendarEvent> events = new HashSet();
        String url = this.urlCreator.constructUrl(calendarConfiguration, period, request);
        this.log.debug((Object)("generated url: " + url));
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(url));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            Calendar calendar = this.retrieveCalendar(url, period, this.credentialsExtractor.getCredentials(request));
            events.addAll(this.convertCalendarToEvents(calendarConfiguration.getId(), calendar, period));
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            cachedElement = new Element((Object)key, events);
            this.cache.put(cachedElement);
        } else {
            events = (Set)((Object)cachedElement.getValue());
        }
        return events;
    }

    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, HttpServletRequest request) throws CalendarException {
        HashSet<CalendarEvent> events = new HashSet();
        String url = this.urlCreator.constructUrl(calendarConfiguration, period, request);
        this.log.debug((Object)("generated url: " + url));
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(url));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            Calendar calendar = this.retrieveCalendar(url, period, this.credentialsExtractor.getCredentials(request));
            events.addAll(this.convertCalendarToEvents(calendarConfiguration.getId(), calendar, period));
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            cachedElement = new Element((Object)key, events);
            this.cache.put(cachedElement);
        } else {
            events = (Set)((Object)cachedElement.getValue());
        }
        return events;
    }

    public String getLink(CalendarConfiguration calendar, Period period, PortletRequest request) throws CalendarLinkException {
        throw new CalendarLinkException("This calendar has no link");
    }

    protected final Calendar retrieveCalendar(String url, Period period, Credentials credentials) {
        try {
            URL hostUrl = new URL(url);
            int port = hostUrl.getPort();
            if (port == -1) {
                port = hostUrl.getDefaultPort();
            }
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(hostUrl.getHost(), port, Protocol.getProtocol((String)hostUrl.getProtocol()));
            CalDAVCalendarCollection collection = new CalDAVCalendarCollection(url, hostConfiguration, new CalDAV4JMethodFactory(), "-//OSAF//NONSGML CalDAV4j Client//EN");
            HttpClient client = new HttpClient();
            client.setHostConfiguration(hostConfiguration);
            if (credentials != null) {
                client.getState().setCredentials(AuthScope.ANY, credentials);
            }
            Calendar cal = collection.getCalendarByPath(client, hostUrl.getPath());
            return cal;
        }
        catch (CalDAV4JException e) {
            this.log.error((Object)"CalDAV exception: ", (Throwable)e);
            throw new CalendarException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CalendarException((Throwable)e);
        }
        catch (Exception e) {
            throw new CalendarException("Unknown exception while retrieving calendar", (Throwable)e);
        }
    }

    protected final Set<CalendarEvent> convertCalendarToEvents(Long calendarId, Calendar calendar, Period period) throws CalendarException {
        HashSet<CalendarEvent> events = new HashSet<CalendarEvent>();
        if (calendar == null) {
            this.log.warn((Object)"calendar was empty, returning empty set");
            return Collections.emptySet();
        }
        for (Component component : calendar.getComponents()) {
            if (!component.getName().equals("VEVENT")) continue;
            VEvent event = (VEvent)component;
            this.log.trace((Object)("processing event " + event.getSummary().getValue()));
            PeriodList periods = event.calculateRecurrenceSet(period);
            for (Period eventper : periods) {
                PropertyList props = event.getProperties();
                PropertyList newprops = new PropertyList();
                newprops.add((Property)new DtStart((Date)eventper.getStart()));
                newprops.add((Property)new DtEnd((Date)eventper.getEnd()));
                for (Property prop : props) {
                    if (prop instanceof DtStart || prop instanceof DtEnd || prop instanceof Duration || prop instanceof RRule) continue;
                    newprops.add(prop);
                }
                CalendarEvent newevent = new CalendarEvent(calendarId, newprops);
                events.add(newevent);
                this.log.trace((Object)("added event " + newevent));
            }
        }
        return events;
    }
}

