/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.jasig.portlet.calendar.PredefinedCalendarDefinition;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.mvc.CalendarDefinitionForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@RequestMapping(value={"EDIT"})
public class EditCalendarDefinitionController {
    private static final String FORM_NAME = "calendarDefinitionForm";
    private Validator validator;
    private CalendarStore calendarStore;

    @Autowired(required=true)
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    @RequestMapping(params={"action=editCalendarDefinition"})
    public String showCalendarDefinitionForm(PortletRequest request, Model model) {
        if (!model.containsAttribute(FORM_NAME)) {
            model.addAttribute(FORM_NAME, (Object)this.getCalendarDefinitionForm(request));
        }
        return "/editCalendarDefinition";
    }

    @RequestMapping(params={"action=editCalendarDefinition"})
    public void updateCalendarDefinition(ActionRequest request, ActionResponse response, @ModelAttribute(value="calendarDefinitionForm") CalendarDefinitionForm form, BindingResult result, SessionStatus status) {
        this.validator.validate((Object)form, (Errors)result);
        if (result.hasErrors()) {
            response.setRenderParameter("action", "editCalendarDefinition");
            return;
        }
        PredefinedCalendarDefinition definition = null;
        definition = form.getId() > -1L ? this.calendarStore.getPredefinedCalendarDefinition(form.getId()) : new PredefinedCalendarDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setFname(form.getFname());
        definition.setParameters(form.getParameters());
        this.calendarStore.storeCalendarDefinition(definition);
        response.setRenderParameter("action", "administration");
    }

    protected CalendarDefinitionForm getCalendarDefinitionForm(PortletRequest request) {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedCalendarDefinition definition = this.calendarStore.getPredefinedCalendarDefinition(definitionId);
                CalendarDefinitionForm command = new CalendarDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setFname(definition.getFname());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                return command;
            }
            return new CalendarDefinitionForm();
        }
        return new CalendarDefinitionForm();
    }
}

