/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.jasig.portlet.calendar.mvc.IViewSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewSelectorDefaultImpl
implements IViewSelector {
    private final String CALENDAR_WIDE_VIEW = "calendarWideView";
    private final String CALENDAR_NARROW_VIEW = "calendarNarrowView";
    private final String CALENDAR_MOBILE_VIEW = "calendarMobileView";
    private List<Pattern> mobileDeviceRegexes = null;

    @Resource(name="mobileDeviceRegexes")
    public void setMobileDeviceRegexes(List<String> patterns) {
        this.mobileDeviceRegexes = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            this.mobileDeviceRegexes.add(Pattern.compile(pattern));
        }
    }

    @Override
    public String getCalendarViewName(PortletRequest request) {
        WindowState state;
        String userAgent = request.getProperty("user-agent");
        if (this.mobileDeviceRegexes != null && userAgent != null) {
            for (Pattern regex : this.mobileDeviceRegexes) {
                if (!regex.matcher(userAgent).matches()) continue;
                return "calendarMobileView";
            }
        }
        if (WindowState.MAXIMIZED.equals((Object)(state = request.getWindowState()))) {
            return "calendarWideView";
        }
        return "calendarNarrowView";
    }

    @Override
    public String getEventListViewName(PortletRequest request) {
        return "ajaxEventList";
    }
}

