/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.Period;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarEvent;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.adapter.ISingleEventSupport;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.jasig.portlet.calendar.processor.ICalendarContentProcessorImpl;
import org.jasig.portlet.calendar.processor.IContentProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableFileCalendarAdapter
implements ICalendarAdapter,
ISingleEventSupport {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private IContentProcessor contentProcessor = new ICalendarContentProcessorImpl();
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "default";

    @Override
    public Set<CalendarEvent> getEvents(CalendarConfiguration calendarConfiguration, Period period, PortletRequest request) throws CalendarException {
        Set<CalendarEvent> events = Collections.emptySet();
        String fileName = calendarConfiguration.getCalendarDefinition().getParameters().get("file");
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, period, request, this.cacheKeyPrefix.concat(".").concat(fileName));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            InputStream stream = this.retrieveCalendar(fileName);
            events = this.contentProcessor.getEvents(calendarConfiguration.getId(), period, stream);
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            cachedElement = new Element((Object)key, events);
            this.cache.put(cachedElement);
        } else {
            events = (Set<CalendarEvent>)((Object)cachedElement.getValue());
        }
        return events;
    }

    @Override
    public CalendarEvent getEvent(CalendarConfiguration calendar, Period period, String uid, String recurrenceId, PortletRequest request) throws CalendarException {
        Set<CalendarEvent> events = this.getEvents(calendar, period, request);
        for (CalendarEvent event : events) {
            if (!event.getUid().toString().equals(uid) || null != recurrenceId && !event.getRecurrenceId().toString().equals(recurrenceId)) continue;
            return event;
        }
        this.log.debug((Object)("event not found with uid " + uid + " and recurrence id " + recurrenceId));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream retrieveCalendar(String fileName) throws CalendarException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieving calendar " + fileName));
        }
        try {
            FileInputStream in = new FileInputStream(fileName);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)buffer);
            return new ByteArrayInputStream(buffer.toByteArray());
        }
        catch (HttpException e) {
            this.log.warn((Object)"Error fetching iCalendar feed", (Throwable)e);
            throw new CalendarException("Error fetching iCalendar feed", e);
        }
        catch (IOException e) {
            this.log.warn((Object)"Error fetching iCalendar feed", (Throwable)e);
            throw new CalendarException("Error fetching iCalendar feed", e);
        }
    }

    @Override
    public String getLink(CalendarConfiguration calendar, Period period, PortletRequest request) {
        throw new CalendarLinkException("This calendar has no link");
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setContentProcessor(IContentProcessor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }
}

