/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web.support;

import edu.wisc.my.portlets.bookmarks.dao.PreferencesStore;
import edu.wisc.my.portlets.bookmarks.domain.Preferences;
import edu.wisc.my.portlets.bookmarks.web.support.NameResolver;
import edu.wisc.my.portlets.bookmarks.web.support.OwnerResolver;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreferencesRequestResolver {
    @Resource(name="preferencesStore")
    protected PreferencesStore preferencesStore;
    @Autowired
    protected OwnerResolver ownerResolver;
    @Autowired
    protected NameResolver nameResolver;

    public Preferences getPreferences(PortletRequest request) {
        return this.getPreferences(request, true);
    }

    public Preferences getPreferences(PortletRequest request, boolean create) {
        String name;
        String owner = this.ownerResolver.getOwner(request);
        Preferences preferences = this.preferencesStore.getPreferences(owner, name = this.nameResolver.getBookmarkSetName(request));
        if (preferences == null && create && (preferences = this.preferencesStore.createPreferences(owner, name)) == null) {
            throw new IllegalStateException("Required Preferences is null even after createPreferences was called.");
        }
        return preferences;
    }
}

