/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web.support;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.web.support.NameResolver;
import edu.wisc.my.portlets.bookmarks.web.support.OwnerResolver;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BookmarkSetRequestResolver {
    @Autowired
    @Resource(name="bookmarkStore")
    protected BookmarkStore bookmarkStore;
    @Autowired
    protected OwnerResolver ownerResolver;
    @Autowired
    protected NameResolver nameResolver;

    public BookmarkSet getBookmarkSet(PortletRequest request) {
        return this.getBookmarkSet(request, true);
    }

    public BookmarkSet getBookmarkSet(PortletRequest request, boolean create) {
        String name;
        String owner = this.ownerResolver.getOwner(request);
        BookmarkSet bookmarkSet = this.bookmarkStore.getBookmarkSet(owner, name = this.nameResolver.getBookmarkSetName(request));
        if (bookmarkSet == null && create && (bookmarkSet = this.bookmarkStore.createBookmarkSet(owner, name)) == null) {
            throw new IllegalStateException("Required BookmarkSet is null even after createBookmarkSet was called.");
        }
        return bookmarkSet;
    }
}

