/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.web;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.CollapsibleEntry;
import edu.wisc.my.portlets.bookmarks.domain.CollectionFolder;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.FolderUtils;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import edu.wisc.my.portlets.bookmarks.domain.validation.BookmarkValidator;
import edu.wisc.my.portlets.bookmarks.domain.validation.CollectionValidator;
import edu.wisc.my.portlets.bookmarks.domain.validation.FolderValidator;
import edu.wisc.my.portlets.bookmarks.web.ReferenceData;
import edu.wisc.my.portlets.bookmarks.web.support.BookmarkSetRequestResolver;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditBookmarksController {
    private static final Logger logger = LoggerFactory.getLogger(EditBookmarksController.class);
    @Autowired
    private BookmarkSetRequestResolver bookmarkSetRequestResolver;
    @Resource(name="bookmarkStore")
    private BookmarkStore bookmarkStore;
    @Autowired
    private ReferenceData referenceData;

    @InitBinder(value={"boookmark"})
    public void initBookmarkBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new BookmarkValidator());
    }

    @InitBinder(value={"folder"})
    public void initFolderBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new FolderValidator());
    }

    @InitBinder(value={"collection"})
    public void initCollectionBinder(WebDataBinder binder) {
        binder.setValidator((Validator)new CollectionValidator());
    }

    @RenderMapping
    public String addDataForView(Model model, RenderRequest request) {
        logger.debug("Entering EDIT addDataForView()");
        BindingResult errors = (BindingResult)request.getAttribute("errors");
        Map<String, Object> refData = this.referenceData.getRefData(request, (Errors)errors);
        model.addAllAttributes(refData);
        return "editBookmarks";
    }

    private boolean foundErrors(ActionRequest request, ActionResponse response, BindingResult result) {
        if (request.getRemoteUser() == null) {
            logger.warn("Guest user attempting to edit bookmarks");
            response.setRenderParameter("action", "viewBookmarks");
            return true;
        }
        if (result.hasErrors()) {
            logger.info("User {} experiencing {} errors", (Object)request.getRemoteUser(), (Object)result.getErrorCount());
            String action = request.getParameter("action");
            String idPath = request.getParameter("idPath");
            String folderPath = request.getParameter("folderPath");
            response.setRenderParameter("action", action);
            response.setRenderParameter("idPath", idPath);
            response.setRenderParameter("folderPath", folderPath);
            request.setAttribute("errors", (Object)result);
            return true;
        }
        logger.debug("No errors for user {}", (Object)request.getRemoteUser());
        response.setRenderParameter("action", "viewBookmarks");
        return false;
    }

    @ActionMapping(params={"action=newBookmark"})
    public void newBookmark(@Valid @ModelAttribute(value="bookmark") Bookmark bookmark, BindingResult result, ActionRequest request, ActionResponse response) {
        Folder targetParent;
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request);
        bookmark.setCreated(new Date());
        bookmark.setModified(bookmark.getCreated());
        if (targetParentPath != null) {
            IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
            if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
                throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
            }
            targetParent = (Folder)targetParentPathInfo.getTarget();
        } else {
            targetParent = bs;
        }
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        targetChildren.put(bookmark.getId(), bookmark);
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=editBookmark"})
    public void editBookmark(@Valid @ModelAttribute(value="bookmark") Bookmark bookmark, BindingResult result, ActionRequest request, ActionResponse response) {
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        String targetEntryPath = StringUtils.defaultIfEmpty((String)request.getParameter("idPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
        if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
        }
        Folder targetParent = (Folder)targetParentPathInfo.getTarget();
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        IdPathInfo originalBookmarkPathInfo = FolderUtils.getEntryInfo(bs, targetEntryPath);
        if (originalBookmarkPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified Bookmark does not exist. BaseFolder='" + bs + "' and idPath='" + targetEntryPath + "'");
        }
        Folder originalParent = originalBookmarkPathInfo.getParent();
        Bookmark originalBookmark = (Bookmark)originalBookmarkPathInfo.getTarget();
        if (targetParent.getId() != originalParent.getId()) {
            Map<Long, Entry> originalChildren = originalParent.getChildren();
            originalChildren.remove(originalBookmark.getId());
            bookmark.setCreated(originalBookmark.getCreated());
            bookmark.setModified(new Date());
            targetChildren.put(bookmark.getId(), bookmark);
        } else {
            originalBookmark.setModified(new Date());
            originalBookmark.setName(bookmark.getName());
            originalBookmark.setNote(bookmark.getNote());
            originalBookmark.setUrl(bookmark.getUrl());
            originalBookmark.setNewWindow(bookmark.isNewWindow());
        }
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=newFolder"})
    public void newFolder(@Valid @ModelAttribute(value="folder") Folder folder, BindingResult result, ActionRequest request, ActionResponse response) {
        Folder targetParent;
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request);
        folder.setCreated(new Date());
        folder.setModified(folder.getCreated());
        if (targetParentPath != null) {
            IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
            if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
                throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
            }
            targetParent = (Folder)targetParentPathInfo.getTarget();
        } else {
            targetParent = bs;
        }
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        targetChildren.put(folder.getId(), folder);
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=editFolder"})
    public void editFolder(@Valid @ModelAttribute(value="folder") Folder folder, BindingResult result, ActionRequest request, ActionResponse response) {
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        String targetEntryPath = StringUtils.defaultIfEmpty((String)request.getParameter("idPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
        if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
        }
        Folder targetParent = (Folder)targetParentPathInfo.getTarget();
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        IdPathInfo originalBookmarkPathInfo = FolderUtils.getEntryInfo(bs, targetEntryPath);
        if (originalBookmarkPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetEntryPath + "'");
        }
        Folder originalParent = originalBookmarkPathInfo.getParent();
        Folder originalFolder = (Folder)originalBookmarkPathInfo.getTarget();
        if (targetParent.getId() != originalParent.getId()) {
            Map<Long, Entry> originalChildren = originalParent.getChildren();
            originalChildren.remove(originalFolder.getId());
            folder.setCreated(originalFolder.getCreated());
            folder.setModified(new Date());
            folder.setChildren(originalFolder.getChildren());
            Folder clonedCommandFolder = FolderUtils.deepCloneFolder(folder, false);
            targetChildren.put(clonedCommandFolder.getId(), clonedCommandFolder);
        } else {
            originalFolder.setModified(new Date());
            originalFolder.setName(folder.getName());
            originalFolder.setNote(folder.getNote());
        }
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=newCollection"})
    public void newCollection(@Valid @ModelAttribute(value="collection") CollectionFolder collection, BindingResult result, ActionRequest request, ActionResponse response) {
        Folder targetParent;
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request);
        collection.setCreated(new Date());
        collection.setModified(collection.getCreated());
        if (targetParentPath != null) {
            IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
            if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
                throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
            }
            targetParent = (Folder)targetParentPathInfo.getTarget();
        } else {
            targetParent = bs;
        }
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        targetChildren.put(collection.getId(), collection);
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=editCollection"})
    public void editCollection(@Valid @ModelAttribute(value="collection") CollectionFolder collection, BindingResult result, ActionRequest request, ActionResponse response) {
        if (this.foundErrors(request, response, result)) {
            return;
        }
        String targetParentPath = StringUtils.defaultIfEmpty((String)request.getParameter("folderPath"), null);
        String targetEntryPath = StringUtils.defaultIfEmpty((String)request.getParameter("idPath"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetParentPathInfo = FolderUtils.getEntryInfo(bs, targetParentPath);
        if (targetParentPathInfo == null || targetParentPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified parent Folder does not exist. BaseFolder='" + bs + "' and idPath='" + targetParentPath + "'");
        }
        Folder targetParent = (Folder)targetParentPathInfo.getTarget();
        Map<Long, Entry> targetChildren = targetParent.getChildren();
        IdPathInfo originalBookmarkPathInfo = FolderUtils.getEntryInfo(bs, targetEntryPath);
        if (originalBookmarkPathInfo.getTarget() == null) {
            throw new IllegalArgumentException("The specified Bookmark does not exist. BaseFolder='" + bs + "' and idPath='" + targetEntryPath + "'");
        }
        Folder originalParent = originalBookmarkPathInfo.getParent();
        CollectionFolder originalCollection = (CollectionFolder)originalBookmarkPathInfo.getTarget();
        if (targetParent.getId() != originalParent.getId()) {
            Map<Long, Entry> originalChildren = originalParent.getChildren();
            originalChildren.remove(originalCollection.getId());
            collection.setCreated(originalCollection.getCreated());
            collection.setModified(new Date());
            targetChildren.put(collection.getId(), collection);
        } else {
            originalCollection.setModified(new Date());
            originalCollection.setName(collection.getName());
            originalCollection.setNote(collection.getNote());
            originalCollection.setUrl(collection.getUrl());
            originalCollection.setMinimized(collection.isMinimized());
        }
        this.bookmarkStore.storeBookmarkSet(bs);
    }

    @ActionMapping(params={"action=toggleFolder"})
    public void toggleFolder(ActionRequest request, ActionResponse response) {
        String folderIndex = StringUtils.defaultIfEmpty((String)request.getParameter("folderIndex"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetFolderPathInfo = FolderUtils.getEntryInfo(bs, folderIndex);
        if (targetFolderPathInfo != null && targetFolderPathInfo.getTarget() != null) {
            CollapsibleEntry targetFolder;
            targetFolder.setMinimized(!(targetFolder = (CollapsibleEntry)((Object)targetFolderPathInfo.getTarget())).isMinimized());
            this.bookmarkStore.storeBookmarkSet(bs);
        } else {
            logger.warn("No IdPathInfo found for BaseFolder='" + bs + "' and idPath='" + folderIndex + "'");
        }
        response.setRenderParameter("action", "viewBookmarks");
    }

    @ActionMapping(params={"action=deleteEntry"})
    public void deleteEntry(ActionRequest request, ActionResponse response) {
        if (request.getRemoteUser() == null) {
            return;
        }
        String entryIndex = StringUtils.defaultIfEmpty((String)request.getParameter("entryIndex"), null);
        BookmarkSet bs = this.bookmarkSetRequestResolver.getBookmarkSet((PortletRequest)request, false);
        if (bs == null) {
            throw new IllegalArgumentException("No BookmarkSet exists for request='" + request + "'");
        }
        IdPathInfo targetEntryPathInfo = FolderUtils.getEntryInfo(bs, entryIndex);
        if (targetEntryPathInfo != null && targetEntryPathInfo.getTarget() != null) {
            Folder parentFolder = targetEntryPathInfo.getParent();
            if (parentFolder != null) {
                Map<Long, Entry> children = parentFolder.getChildren();
                Entry target = targetEntryPathInfo.getTarget();
                children.remove(target.getId());
                this.bookmarkStore.storeBookmarkSet(bs);
            } else {
                this.bookmarkStore.removeBookmarkSet(bs.getOwner(), bs.getName());
            }
        } else {
            logger.warn("No IdPathInfo found for BaseFolder='" + bs + "' and idPath='" + entryIndex + "'");
        }
        response.setRenderParameter("action", "viewBookmarks");
    }
}

