/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain.validation;

import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.validation.EntryValidator;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public class BookmarkValidator
extends EntryValidator {
    private static final String PROTOCOL_SEPERATOR = "://";
    private String defaultProtocol = "http://";

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        if (defaultProtocol == null) {
            throw new IllegalArgumentException("defaultProtocol may not be null.");
        }
        if (!defaultProtocol.endsWith(PROTOCOL_SEPERATOR)) {
            throw new IllegalArgumentException("defaultProtocol must end with a the protocol seperator='://'.");
        }
        this.defaultProtocol = defaultProtocol;
    }

    @Override
    public boolean supports(Class clazz) {
        return Bookmark.class.isAssignableFrom(clazz) && super.supports(clazz);
    }

    @Override
    public void validate(Object obj, Errors errors) {
        super.validate(obj, errors);
        Bookmark bookmark = (Bookmark)obj;
        this.validateUrl(bookmark, errors);
    }

    private void validateUrl(Bookmark bookmark, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"url", (String)"portlet.bookmark.error.url.required");
        String url = bookmark.getUrl();
        if (!url.contains(PROTOCOL_SEPERATOR)) {
            url = this.defaultProtocol + url;
        }
        bookmark.setUrl(url);
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            errors.rejectValue("url", "portlet.bookmark.error.url.malformed");
        }
    }
}

