/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain.support;

import edu.wisc.my.portlets.bookmarks.domain.Bookmark;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.Folder;
import edu.wisc.my.portlets.bookmarks.domain.support.IdPathInfo;
import java.util.HashMap;
import java.util.Map;

public final class FolderUtils {
    private FolderUtils() {
    }

    public static IdPathInfo getEntryInfo(Folder baseFolder, String indexPath) {
        return FolderUtils.getEntryInfo(baseFolder, indexPath, "\\.");
    }

    public static IdPathInfo getEntryInfo(Folder baseFolder, String idPath, String regexDelimeter) {
        if (baseFolder == null) {
            throw new IllegalArgumentException("The base Folder can not be null.");
        }
        if (idPath == null) {
            throw new IllegalArgumentException("The ID path can not be null.");
        }
        if (regexDelimeter == null) {
            throw new IllegalArgumentException("The regexDelimeter can not be null.");
        }
        String[] stringIds = idPath.split(regexDelimeter);
        long[] ids = new long[stringIds.length];
        ids[0] = Long.parseLong(stringIds[0]);
        Folder parent = null;
        Entry target = baseFolder;
        for (int idIndex = 1; idIndex < stringIds.length; ++idIndex) {
            long entryId = Long.parseLong(stringIds[idIndex]);
            if (!(target instanceof Folder)) {
                return null;
            }
            parent = target;
            Map<Long, Entry> children = parent.getChildren();
            target = children.get(entryId);
            ids[idIndex] = entryId;
        }
        IdPathInfo pathInfo = new IdPathInfo(ids, parent, target);
        return pathInfo;
    }

    public static boolean deepContains(Folder parent, Entry query) {
        Map<Long, Entry> children = parent.getChildren();
        for (Map.Entry<Long, Entry> mapEntry : children.entrySet()) {
            Entry child = mapEntry.getValue();
            if (child.equals(query)) {
                return true;
            }
            if (!(child instanceof Folder)) continue;
            return FolderUtils.deepContains((Folder)child, query);
        }
        return false;
    }

    public static Entry deepClone(Entry target, boolean copyIds) {
        if (target instanceof BookmarkSet) {
            return FolderUtils.deepCloneBookmarkSet((BookmarkSet)target, copyIds);
        }
        if (target instanceof Folder) {
            return FolderUtils.deepCloneFolder((Folder)target, copyIds);
        }
        if (target instanceof Bookmark) {
            return FolderUtils.deepCloneBookmark((Bookmark)target, copyIds);
        }
        return FolderUtils.deepCloneEntry(target, copyIds);
    }

    public static Entry deepCloneEntry(Entry target, boolean copyIds) {
        if (target == null) {
            return null;
        }
        Entry clone = new Entry();
        FolderUtils.copyEntryFields(target, clone, copyIds);
        return clone;
    }

    public static Bookmark deepCloneBookmark(Bookmark target, boolean copyIds) {
        if (target == null) {
            return null;
        }
        Bookmark clone = new Bookmark();
        FolderUtils.copyEntryFields(target, clone, copyIds);
        FolderUtils.copyBookmarkFields(target, clone);
        return clone;
    }

    public static Folder deepCloneFolder(Folder target, boolean copyIds) {
        if (target == null) {
            return null;
        }
        Folder clone = new Folder();
        FolderUtils.copyEntryFields(target, clone, copyIds);
        FolderUtils.copyFolderFields(target, clone, copyIds);
        return clone;
    }

    public static BookmarkSet deepCloneBookmarkSet(BookmarkSet target, boolean copyIds) {
        if (target == null) {
            return null;
        }
        BookmarkSet clone = new BookmarkSet();
        FolderUtils.copyEntryFields(target, clone, copyIds);
        FolderUtils.copyFolderFields(target, clone, copyIds);
        FolderUtils.copyBookmarkSetFields(target, clone);
        return clone;
    }

    private static void copyBookmarkSetFields(BookmarkSet target, BookmarkSet clone) {
        target.setName(clone.getName());
    }

    private static void copyBookmarkFields(Bookmark target, Bookmark clone) {
        clone.setUrl(target.getUrl());
        clone.setNewWindow(target.isNewWindow());
    }

    private static void copyFolderFields(Folder target, Folder clone, boolean copyIds) {
        clone.setMinimized(target.isMinimized());
        clone.setChildComparator(target.getChildComparator());
        HashMap<Long, Entry> clonedChildren = new HashMap<Long, Entry>();
        Map<Long, Entry> children = target.getChildren();
        for (Entry targetEntry : children.values()) {
            Entry clonedEntry = FolderUtils.deepClone(targetEntry, copyIds);
            if (copyIds) {
                clonedChildren.put(clonedEntry.getId(), clonedEntry);
                continue;
            }
            clonedChildren.put(Long.valueOf(clonedEntry.hashCode()), clonedEntry);
        }
        clone.setChildren(clonedChildren);
    }

    private static void copyEntryFields(Entry target, Entry clone, boolean copyIds) {
        if (copyIds) {
            clone.setId(target.getId());
        }
        clone.setName(target.getName());
        clone.setNote(target.getNote());
        clone.setCreated(target.getCreated());
        clone.setModified(target.getModified());
    }
}

