/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.dao.file;

import edu.wisc.my.portlets.bookmarks.dao.BookmarkStore;
import edu.wisc.my.portlets.bookmarks.domain.BookmarkSet;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;

public class FileSystemBookmarkStore
implements BookmarkStore {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String baseStorePath = null;

    public String getBaseStorePath() {
        return this.baseStorePath;
    }

    public void setBaseStorePath(String baseStorePath) {
        this.baseStorePath = baseStorePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookmarkSet getBookmarkSet(String owner, String name) {
        File storeFile = this.getStoreFile(owner, name);
        if (!storeFile.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(storeFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        XMLDecoder d = new XMLDecoder(bis);
        try {
            BookmarkSet bs;
            BookmarkSet bookmarkSet = bs = (BookmarkSet)d.readObject();
            d.close();
            return bookmarkSet;
        }
        catch (Throwable throwable) {
            try {
                d.close();
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                String errorMsg = "Error reading BookmarkSet for owner='" + owner + "', name='" + name + "' from file='" + storeFile + "'";
                this.logger.error((Object)errorMsg, (Throwable)fnfe);
                throw new DataAccessResourceFailureException(errorMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBookmarkSet(BookmarkSet bookmarkSet) {
        if (bookmarkSet == null) {
            throw new IllegalArgumentException("AddressBook may not be null");
        }
        File storeFile = this.getStoreFile(bookmarkSet.getOwner(), bookmarkSet.getName());
        try {
            FileOutputStream fos = new FileOutputStream(storeFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try (XMLEncoder e = new XMLEncoder(bos);){
                e.writeObject(bookmarkSet);
            }
        }
        catch (FileNotFoundException fnfe) {
            String errorMsg = "Error storing BookmarkSet='" + bookmarkSet + "' to file='" + storeFile + "'";
            this.logger.error((Object)errorMsg, (Throwable)fnfe);
            throw new DataAccessResourceFailureException(errorMsg, (Throwable)fnfe);
        }
    }

    @Override
    public void removeBookmarkSet(String owner, String name) {
        File storeFile = this.getStoreFile(owner, name);
        storeFile.delete();
    }

    @Override
    public BookmarkSet createBookmarkSet(String owner, String name) {
        BookmarkSet bookmarkSet = new BookmarkSet();
        bookmarkSet.setOwner(owner);
        bookmarkSet.setName(name);
        bookmarkSet.setCreated(new Date());
        bookmarkSet.setModified(bookmarkSet.getCreated());
        this.storeBookmarkSet(bookmarkSet);
        return bookmarkSet;
    }

    protected String getStoreFileName(String owner, String name) {
        StringBuilder fileNameBuff = new StringBuilder();
        fileNameBuff.append(owner != null ? "_" + owner : "null");
        fileNameBuff.append("_");
        fileNameBuff.append(name != null ? "_" + name : "null");
        fileNameBuff.append(".bms.xml");
        return fileNameBuff.toString();
    }

    protected File getStoreFile(String owner, String name) {
        String fileStoreName = this.getStoreFileName(owner, name);
        File basePath = this.getStoreDirectory();
        File storeFile = new File(basePath, fileStoreName);
        return storeFile;
    }

    protected File getStoreDirectory() {
        return this.baseStorePath == null ? new File(".") : new File(this.baseStorePath);
    }
}

