/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.domain;

import edu.wisc.my.portlets.bookmarks.domain.CollapsibleEntry;
import edu.wisc.my.portlets.bookmarks.domain.Entry;
import edu.wisc.my.portlets.bookmarks.domain.compare.DefaultBookmarksComparator;
import edu.wisc.my.portlets.bookmarks.domain.support.IntegerSetThreadLocal;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Folder
extends Entry
implements CollapsibleEntry {
    private static final long serialVersionUID = 1L;
    private static IntegerSetThreadLocal equalsVisitedFolder = new IntegerSetThreadLocal();
    private static IntegerSetThreadLocal hashCodeVisitedFolder = new IntegerSetThreadLocal();
    private static IntegerSetThreadLocal toStringVisitedFolder = new IntegerSetThreadLocal();
    private Map<Long, Entry> children;
    private transient Comparator<Entry> childComparator = DefaultBookmarksComparator.DEFAULT_BOOKMARKS_COMPARATOR;
    private boolean minimized = false;

    public synchronized Map<Long, Entry> getChildren() {
        if (this.children == null) {
            this.children = new HashMap();
        }
        return this.children;
    }

    public void setChildren(Map<Long, Entry> children) {
        this.children = children;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    public List<Entry> getSortedChildren() {
        if (this.children == null) {
            return null;
        }
        Collection childCollection = this.children.values();
        ArrayList childList = new ArrayList(childCollection);
        Collections.sort(childList, this.childComparator);
        return Collections.unmodifiableList(childList);
    }

    public Comparator<Entry> getChildComparator() {
        return this.childComparator;
    }

    public void setChildComparator(Comparator<Entry> childComparator) {
        if (childComparator == null) {
            throw new IllegalArgumentException("childComparator cannot be null");
        }
        this.childComparator = childComparator;
        if (this.children != null) {
            for (Map.Entry entry : this.children.entrySet()) {
                Entry child = (Entry)entry.getValue();
                if (!(child instanceof Folder)) continue;
                ((Folder)child).setChildComparator(childComparator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        Set visited = equalsVisitedFolder.getSet();
        int identityHash = System.identityHashCode(this);
        try {
            if (!visited.add(identityHash)) {
                visited.clear();
                throw new IllegalStateException("A loop exists in the Folder tree.");
            }
            if (object == this) {
                boolean bl = true;
                return bl;
            }
            if (!(object instanceof Folder)) {
                boolean bl = false;
                return bl;
            }
            Folder rhs = (Folder)object;
            boolean bl = new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.children, (Object)rhs.children).append(this.minimized, rhs.minimized).isEquals();
            return bl;
        }
        finally {
            visited.remove(identityHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Set visited = hashCodeVisitedFolder.getSet();
        int identityHash = System.identityHashCode(this);
        try {
            if (!visited.add(identityHash)) {
                visited.clear();
                throw new IllegalStateException("A loop exists in the Folder tree.");
            }
            int n = new HashCodeBuilder(-409984457, 961354191).appendSuper(super.hashCode()).append((Object)this.children).append(this.minimized).toHashCode();
            return n;
        }
        finally {
            visited.remove(identityHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Set visited = toStringVisitedFolder.getSet();
        int identityHash = System.identityHashCode(this);
        try {
            if (!visited.add(identityHash)) {
                visited.clear();
                throw new IllegalStateException("A loop exists in the Folder tree.");
            }
            String string = new ToStringBuilder((Object)this).appendSuper(super.toString()).append("children", (Object)this.children).append("minimized", this.minimized).toString();
            return string;
        }
        finally {
            visited.remove(identityHash);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.childComparator instanceof Serializable) {
            out.writeObject(this.childComparator);
        } else {
            out.writeObject(this.childComparator.getClass());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object comparatorInfo = in.readObject();
        if (comparatorInfo instanceof Comparator) {
            this.childComparator = this.castComparator(comparatorInfo);
        } else if (comparatorInfo instanceof Class && Comparator.class.isAssignableFrom((Class)comparatorInfo)) {
            try {
                Object instance = ((Class)comparatorInfo).newInstance();
                this.childComparator = this.castComparator(instance);
            }
            catch (InstantiationException e) {
                this.childComparator = DefaultBookmarksComparator.DEFAULT_BOOKMARKS_COMPARATOR;
            }
            catch (IllegalAccessException e) {
                this.childComparator = DefaultBookmarksComparator.DEFAULT_BOOKMARKS_COMPARATOR;
            }
        } else {
            this.childComparator = DefaultBookmarksComparator.DEFAULT_BOOKMARKS_COMPARATOR;
        }
    }

    private Comparator<Entry> castComparator(Object obj) {
        return (Comparator)obj;
    }
}

