/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.portlets.bookmarks.dao.hibernate;

import edu.wisc.my.portlets.bookmarks.dao.PreferencesStore;
import edu.wisc.my.portlets.bookmarks.domain.Preferences;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernatePreferencesStore
extends HibernateDaoSupport
implements PreferencesStore {
    private static final String PARAM_OWNER = "owner";
    private static final String PARAM_NAME = "name";

    public Preferences getPreferences(String owner, String name) {
        try {
            Session session = this.getSession(false);
            Criteria c = session.createCriteria(Preferences.class);
            c.add((Criterion)Restrictions.and((Criterion)this.smartEqual(PARAM_NAME, (Object)name), (Criterion)this.smartEqual(PARAM_OWNER, (Object)owner)));
            c.setCacheable(true);
            Preferences bs = (Preferences)c.uniqueResult();
            return bs;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void storePreferences(Preferences bookmarkSet) {
        try {
            Session session = this.getSession(false);
            if (bookmarkSet.getId() == -1L) {
                session.save((Object)bookmarkSet);
            }
            session.update((Object)bookmarkSet);
            session.flush();
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public void removePreferences(String owner, String name) {
        try {
            try {
                Session session = this.getSession(false);
                Preferences prefs = this.getPreferences(owner, name);
                if (prefs != null) {
                    session.delete((Object)prefs);
                }
                session.flush();
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    public Preferences createPreferences(String owner, String name) {
        Preferences bookmarkSet = new Preferences();
        bookmarkSet.setOwner(owner);
        bookmarkSet.setName(name);
        bookmarkSet.setCreated(new Date());
        bookmarkSet.setModified(bookmarkSet.getCreated());
        this.storePreferences(bookmarkSet);
        return bookmarkSet;
    }

    private Criterion smartEqual(String property, Object value) {
        if (value == null) {
            return Restrictions.isNull((String)property);
        }
        return Restrictions.eq((String)property, (Object)value);
    }
}

