/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.security.provider;

import org.apereo.portal.AuthorizationException;
import org.apereo.portal.security.IAuthorizationPrincipal;
import org.apereo.portal.security.IPermission;
import org.apereo.portal.security.IPermissionManager;
import org.apereo.portal.security.provider.AuthorizationImpl;

public class PermissionManagerImpl
implements IPermissionManager {
    private AuthorizationImpl authorizationService;
    private String owner;

    public PermissionManagerImpl(String newOwner, AuthorizationImpl authService) {
        this.owner = newOwner;
        this.authorizationService = authService;
    }

    AuthorizationImpl getAuthorizationService() {
        return this.authorizationService;
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getAuthorizedPrincipals(this.getOwner(), activity, target);
    }

    public String getOwner() {
        return this.owner;
    }

    public IPermission[] getPermissionsForTarget(String target) {
        return this.getAuthorizationService().getPermissionsForTarget(this.getOwner(), target);
    }

    public IPermission[] getPermissions(String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getPermissionsForOwner(this.getOwner(), activity, target);
    }
}

