/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.security.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apereo.portal.AuthorizationException;
import org.apereo.portal.IBasicEntity;
import org.apereo.portal.concurrency.CachingException;
import org.apereo.portal.concurrency.caching.RequestCache;
import org.apereo.portal.groups.GroupsException;
import org.apereo.portal.groups.ICompositeGroupService;
import org.apereo.portal.groups.IEntityGroup;
import org.apereo.portal.groups.IGroupMember;
import org.apereo.portal.permission.IPermissionActivity;
import org.apereo.portal.permission.IPermissionOwner;
import org.apereo.portal.permission.dao.IPermissionOwnerDao;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.IPermissionTargetProviderRegistry;
import org.apereo.portal.portlet.om.IPortletDefinition;
import org.apereo.portal.portlet.om.IPortletLifecycleEntry;
import org.apereo.portal.portlet.om.PortletCategory;
import org.apereo.portal.portlet.om.PortletLifecycleState;
import org.apereo.portal.portlet.registry.IPortletDefinitionRegistry;
import org.apereo.portal.security.IAuthorizationPrincipal;
import org.apereo.portal.security.IAuthorizationService;
import org.apereo.portal.security.IPermission;
import org.apereo.portal.security.IPermissionManager;
import org.apereo.portal.security.IPermissionPolicy;
import org.apereo.portal.security.IPermissionSet;
import org.apereo.portal.security.IPermissionStore;
import org.apereo.portal.security.IPerson;
import org.apereo.portal.security.IUpdatingPermissionManager;
import org.apereo.portal.security.PermissionHelper;
import org.apereo.portal.security.provider.AuthorizationPrincipalImpl;
import org.apereo.portal.security.provider.PermissionManagerImpl;
import org.apereo.portal.security.provider.PermissionSetImpl;
import org.apereo.portal.security.provider.UpdatingPermissionManagerImpl;
import org.apereo.portal.services.EntityCachingService;
import org.apereo.portal.services.GroupService;
import org.apereo.portal.spring.locator.EntityTypesLocator;
import org.apereo.portal.spring.locator.PortletCategoryRegistryLocator;
import org.apereo.portal.utils.Tuple;
import org.apereo.portal.utils.cache.CacheKey;
import org.apereo.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="authorizationService")
public class AuthorizationImpl
implements IAuthorizationService {
    private static final long MISSING_DATA_LOG_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRINCIPAL_SEPARATOR = ".";
    private IPermissionStore permissionStore;
    private IPermissionPolicy defaultPermissionPolicy;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPermissionOwnerDao permissionOwner;
    private Ehcache principalCache;
    private Ehcache entityParentsCache;
    private Ehcache doesPrincipalHavePermissionCache;
    private static final Class<IPermissionSet> PERMISSION_SET_TYPE = IPermissionSet.class;
    private boolean cachePermissions = true;
    private Set<String> nonEntityPermissionTargetProviders = new HashSet<String>();
    private Map<Object, Long> missingDataLogTracker = new ConcurrentHashMap<Object, Long>();
    @Autowired
    private IPermissionOwnerDao permissionOwnerDao;
    @Autowired
    private IPermissionTargetProviderRegistry targetProviderRegistry;

    @Autowired
    public void setDefaultPermissionPolicy(IPermissionPolicy newDefaultPermissionPolicy) {
        this.defaultPermissionPolicy = newDefaultPermissionPolicy;
    }

    @Autowired
    public void setPermissionStore(IPermissionStore permissionStore) {
        this.permissionStore = permissionStore;
    }

    @Value(value="${org.apereo.portal.security.IAuthorizationService.cachePermissions}")
    public void setCachePermissions(boolean cachePermissions) {
        this.cachePermissions = cachePermissions;
    }

    @Autowired
    public void setPrincipalCache(@Qualifier(value="org.apereo.portal.security.provider.AuthorizationImpl.AUTH_PRINCIPAL_CACHE") Ehcache principalCache) {
        this.principalCache = new SelfPopulatingCache(principalCache, new CacheEntryFactory(){

            public Object createEntry(Object key) throws Exception {
                Tuple principalKey = (Tuple)key;
                return AuthorizationImpl.this.primNewPrincipal((String)principalKey.first, (Class)principalKey.second);
            }
        });
    }

    @Autowired
    public void setEntityParentsCache(@Qualifier(value="org.apereo.portal.security.provider.AuthorizationImpl.ENTITY_PARENTS_CACHE") Ehcache entityParentsCache) {
        this.entityParentsCache = entityParentsCache;
    }

    @Autowired
    public void setDoesPrincipalHavePermissionCache(@Qualifier(value="org.apereo.portal.security.provider.AuthorizationImpl.PRINCIPAL_HAS_PERMISSION") Ehcache doesPrincipalHavePermissionCache) {
        this.doesPrincipalHavePermissionCache = doesPrincipalHavePermissionCache;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPermissionOwner(IPermissionOwnerDao permissionOwner) {
        this.permissionOwner = permissionOwner;
    }

    public void setNonEntityPermissionTargetProviders(Set<String> nonEntityPermissionTargetProviders) {
        this.nonEntityPermissionTargetProviders = nonEntityPermissionTargetProviders;
    }

    public void addPermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().add(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    protected void cacheAdd(IPermissionSet ps) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().add((IBasicEntity)ps);
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem adding permissions for " + ps + " to cache", (Throwable)ce);
        }
    }

    protected IPermissionSet cacheGet(IAuthorizationPrincipal principal) throws AuthorizationException {
        try {
            return (IPermissionSet)EntityCachingService.getEntityCachingService().get(PERMISSION_SET_TYPE, principal.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem getting permissions for " + principal + " from cache", (Throwable)ce);
        }
    }

    protected void cacheRemove(IAuthorizationPrincipal ap) throws AuthorizationException {
        try {
            EntityCachingService.getEntityCachingService().remove(PERMISSION_SET_TYPE, ap.getPrincipalString());
        }
        catch (CachingException ce) {
            throw new AuthorizationException("Problem removing permissions for " + ap + " from cache", (Throwable)ce);
        }
    }

    @RequestCache
    public boolean canPrincipalConfigure(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        String owner = "UP_PORTLET_PUBLISH";
        String target = "PORTLET_ID." + portletDefinitionId;
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            throw new AuthorizationException("Unable to locate portlet " + portletDefinitionId);
        }
        String activity = "PORTLET_MODE_CONFIG";
        boolean isAllowed = this.doesPrincipalHavePermission(principal, owner, "PORTLET_MODE_CONFIG", target);
        this.logger.trace("In canPrincipalConfigure() - principal.key=[{}], is allowed?=[{}]", (Object)principal.getKey(), (Object)isAllowed);
        return isAllowed;
    }

    @RequestCache
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        String activity;
        String owner = "UP_PORTLET_PUBLISH";
        String target = "PORTLET_ID." + portletDefinitionId;
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            return this.doesPrincipalHavePermission(principal, "UP_PORTLET_PUBLISH", "MANAGE_APPROVED", target);
        }
        IPortletLifecycleEntry highestLifecycleEntryDefined = (IPortletLifecycleEntry)portlet.getLifecycle().get(portlet.getLifecycle().size() - 1);
        switch (highestLifecycleEntryDefined.getLifecycleState()) {
            case CREATED: {
                activity = "MANAGE_CREATED";
                break;
            }
            case APPROVED: {
                activity = "MANAGE_APPROVED";
                break;
            }
            case PUBLISHED: {
                activity = "MANAGE";
                break;
            }
            case EXPIRED: {
                activity = "MANAGE_EXPIRED";
                break;
            }
            case MAINTENANCE: {
                activity = "MANAGE_MAINTENANCE";
                break;
            }
            default: {
                String msg = "Unrecognized portlet lifecycle state:  " + highestLifecycleEntryDefined.getLifecycleState();
                throw new IllegalStateException(msg);
            }
        }
        return this.doesPrincipalHavePermission(principal, "UP_PORTLET_PUBLISH", activity, target);
    }

    @RequestCache
    public boolean canPrincipalManage(IAuthorizationPrincipal principal, PortletLifecycleState state, String categoryId) throws AuthorizationException {
        String owner = "UP_PORTLET_PUBLISH";
        PortletCategory category = PortletCategoryRegistryLocator.getPortletCategoryRegistry().getPortletCategory(categoryId);
        if (category == null) {
            throw new AuthorizationException("Unable to locate category " + categoryId);
        }
        int order = state.getOrder();
        String activity = "MANAGE_MAINTENANCE";
        if (order <= PortletLifecycleState.MAINTENANCE.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE_EXPIRED";
        if (order <= PortletLifecycleState.EXPIRED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE";
        if (order <= PortletLifecycleState.PUBLISHED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE_APPROVED";
        if (order <= PortletLifecycleState.APPROVED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId)) {
            return true;
        }
        activity = "MANAGE_CREATED";
        return order <= PortletLifecycleState.CREATED.getOrder() && this.doesPrincipalHavePermission(principal, owner, activity, categoryId);
    }

    @RequestCache
    public boolean canPrincipalRender(IAuthorizationPrincipal principal, String portletDefinitionId) throws AuthorizationException {
        return this.canPrincipalSubscribe(principal, portletDefinitionId);
    }

    @RequestCache
    public boolean canPrincipalBrowse(IAuthorizationPrincipal principal, String portletDefinitionId) {
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            return false;
        }
        return this.canPrincipalBrowse(principal, portlet);
    }

    @RequestCache
    public boolean canPrincipalBrowse(IAuthorizationPrincipal principal, IPortletDefinition portlet) {
        String permission;
        String owner = "UP_PORTLET_SUBSCRIBE";
        String target = PermissionHelper.permissionTargetIdForPortletDefinition((IPortletDefinition)portlet);
        PortletLifecycleState state = portlet.getLifecycleState();
        if (state.equals((Object)PortletLifecycleState.PUBLISHED) || state.equals((Object)PortletLifecycleState.MAINTENANCE)) {
            permission = "BROWSE";
        } else if (state.equals((Object)PortletLifecycleState.APPROVED)) {
            permission = "BROWSE_APPROVED";
        } else if (state.equals((Object)PortletLifecycleState.CREATED)) {
            permission = "BROWSE_CREATED";
        } else if (state.equals((Object)PortletLifecycleState.EXPIRED)) {
            permission = "BROWSE_EXPIRED";
        } else {
            throw new AuthorizationException("Unrecognized lifecycle state for channel " + portlet.getPortletDefinitionId().getStringId());
        }
        return this.doesPrincipalHavePermission(principal, owner, permission, target);
    }

    @RequestCache
    public boolean canPrincipalSubscribe(IAuthorizationPrincipal principal, String portletDefinitionId) {
        String permission;
        String owner = "UP_PORTLET_SUBSCRIBE";
        IPortletDefinition portlet = this.portletDefinitionRegistry.getPortletDefinition(portletDefinitionId);
        if (portlet == null) {
            return false;
        }
        String target = PermissionHelper.permissionTargetIdForPortletDefinition((IPortletDefinition)portlet);
        PortletLifecycleState state = portlet.getLifecycleState();
        if (state.equals((Object)PortletLifecycleState.PUBLISHED) || state.equals((Object)PortletLifecycleState.MAINTENANCE)) {
            permission = "SUBSCRIBE";
        } else if (state.equals((Object)PortletLifecycleState.APPROVED)) {
            permission = "SUBSCRIBE_APPROVED";
        } else if (state.equals((Object)PortletLifecycleState.CREATED)) {
            permission = "SUBSCRIBE_CREATED";
        } else if (state.equals((Object)PortletLifecycleState.EXPIRED)) {
            permission = "SUBSCRIBE_EXPIRED";
        } else {
            throw new AuthorizationException("Unrecognized lifecycle state for channel " + portletDefinitionId);
        }
        return this.doesPrincipalHavePermission(principal, owner, permission, target);
    }

    @RequestCache
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.doesPrincipalHavePermission(principal, owner, activity, target, this.getDefaultPermissionPolicy());
    }

    @RequestCache
    public boolean doesPrincipalHavePermission(IAuthorizationPrincipal principal, String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)AuthorizationImpl.class.getName());
        String username = principal.getKey();
        if (IPerson.class.equals((Object)principal.getType())) {
            cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)username));
        }
        cacheKeyBuilder.addAll(new Serializable[]{policy.getClass(), username, principal.getType(), owner, activity, target});
        CacheKey key = cacheKeyBuilder.build();
        Element element = this.doesPrincipalHavePermissionCache.get((Serializable)key);
        if (element != null) {
            return (Boolean)element.getValue();
        }
        boolean rslt = false;
        IPermissionOwner ipOwner = this.permissionOwnerDao.getPermissionOwner(owner);
        IPermissionActivity ipActivity = this.permissionOwnerDao.getPermissionActivity(owner, activity);
        if (ipActivity != null) {
            IPermissionTargetProvider targetProvider = this.targetProviderRegistry.getTargetProvider(ipActivity.getTargetProviderKey());
            IPermissionTarget ipTarget = targetProvider.getTarget(target);
            rslt = policy.doesPrincipalHavePermission((IAuthorizationService)this, principal, ipOwner, ipActivity, ipTarget);
        } else {
            Long now = System.currentTimeMillis();
            String missingDataTrackerKey = owner + ":" + activity;
            Long lastLogMessageTime = this.missingDataLogTracker.get(missingDataTrackerKey);
            if (lastLogMessageTime == null || lastLogMessageTime < now - MISSING_DATA_LOG_PERIOD_MILLIS) {
                this.logger.warn("Activity '{}' is not defined for owner '{}';  only admins will be able to access this function;  this warning usually means that expected data was not imported", (Object)activity, (Object)owner);
                this.missingDataLogTracker.put(missingDataTrackerKey, now);
            }
            rslt = this.doesPrincipalHavePermission(principal, "UP_SYSTEM", "ALL_PERMISSIONS", "ALL", policy);
        }
        this.doesPrincipalHavePermissionCache.put(new Element((Serializable)key, (Serializable)Boolean.valueOf(rslt)));
        return rslt;
    }

    public IPermission[] getAllPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        IPermission[] perms = this.getPermissionsForPrincipal(principal, owner, activity, target);
        ArrayList<IPermission> al = new ArrayList<IPermission>(Arrays.asList(perms));
        Iterator i = this.getInheritedPrincipals(principal);
        while (i.hasNext()) {
            IAuthorizationPrincipal p = (IAuthorizationPrincipal)i.next();
            perms = this.getPermissionsForPrincipal(p, owner, activity, target);
            al.addAll(Arrays.asList(perms));
        }
        this.logger.trace("query for all permissions for principal=[{}], owner=[{}], activity=[{}], target=[{}] returned permissions [{}]", new Object[]{principal, owner, activity, target, al});
        return al.toArray(new IPermission[al.size()]);
    }

    public IAuthorizationPrincipal[] getAuthorizedPrincipals(String owner, String activity, String target) throws AuthorizationException {
        IPermission[] permissions = this.getPermissionsForOwner(owner, activity, target);
        return this.getPrincipalsFromPermissions(permissions);
    }

    protected IPermissionPolicy getDefaultPermissionPolicy() {
        return this.defaultPermissionPolicy;
    }

    public IGroupMember getGroupMember(IAuthorizationPrincipal principal) throws GroupsException {
        return this.getGroupMemberForPrincipal(principal);
    }

    private IGroupMember getGroupMemberForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = GroupService.getGroupMember((String)principal.getKey(), (Class)principal.getType());
        this.logger.debug("AuthorizationImpl.getGroupMemberForPrincipal(): principal [{}] got group member [{}]", (Object)principal, (Object)gm);
        return gm;
    }

    private Iterator getGroupsForPrincipal(IAuthorizationPrincipal principal) throws GroupsException {
        IGroupMember gm = this.getGroupMemberForPrincipal(principal);
        return gm.getAncestorGroups().iterator();
    }

    private Iterator getInheritedPrincipals(IAuthorizationPrincipal principal) throws AuthorizationException {
        Iterator i = null;
        ArrayList<IAuthorizationPrincipal> al = new ArrayList<IAuthorizationPrincipal>(5);
        try {
            i = this.getGroupsForPrincipal(principal);
        }
        catch (GroupsException ge) {
            throw new AuthorizationException("Could not retrieve Groups for " + principal, (Throwable)ge);
        }
        while (i.hasNext()) {
            IEntityGroup group = (IEntityGroup)i.next();
            IAuthorizationPrincipal p = this.getPrincipalForGroup(group);
            al.add(p);
        }
        return al.iterator();
    }

    public IPermission[] getPermissionsForOwner(String owner, String activity, String target) throws AuthorizationException {
        return this.primRetrievePermissions(owner, null, activity, target);
    }

    @RequestCache
    public IPermission[] getPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        return this.primGetPermissionsForPrincipal(principal, owner, activity, target);
    }

    public IPermission[] getPermissionsForTarget(String owner, String target) {
        return this.getPermissionStore().select(owner, null, null, target, null);
    }

    private IPermissionStore getPermissionStore() {
        return this.permissionStore;
    }

    public IAuthorizationPrincipal getPrincipal(IPermission permission) throws AuthorizationException {
        String principalString = permission.getPrincipal();
        int idx = principalString.indexOf(PRINCIPAL_SEPARATOR);
        Integer typeId = Integer.valueOf(principalString.substring(0, idx));
        Class type = EntityTypesLocator.getEntityTypes().getEntityTypeFromID(typeId);
        String key = principalString.substring(idx + 1);
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal getPrincipalForGroup(IEntityGroup group) {
        String key = group.getKey();
        Class type = ICompositeGroupService.GROUP_ENTITY_TYPE;
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal[] getPrincipalsFromPermissions(IPermission[] permissions) throws AuthorizationException {
        HashSet<IAuthorizationPrincipal> principals = new HashSet<IAuthorizationPrincipal>();
        for (int i = 0; i < permissions.length; ++i) {
            IAuthorizationPrincipal principal = this.getPrincipal(permissions[i]);
            principals.add(principal);
        }
        return principals.toArray(new IAuthorizationPrincipal[principals.size()]);
    }

    public String getPrincipalString(IAuthorizationPrincipal principal) {
        return this.getPrincipalString(principal.getType(), principal.getKey());
    }

    private String getPrincipalString(Class pType, String pKey) {
        Integer type = EntityTypesLocator.getEntityTypes().getEntityIDFromType(pType);
        return type + PRINCIPAL_SEPARATOR + pKey;
    }

    public IPermission[] getUncachedPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        String pString = this.getPrincipalString(principal);
        return this.primRetrievePermissions(owner, pString, activity, target);
    }

    public IPermission newPermission(String owner, IAuthorizationPrincipal principal) {
        IPermission p = this.getPermissionStore().newInstance(owner);
        if (principal != null) {
            String pString = this.getPrincipalString(principal);
            p.setPrincipal(pString);
        }
        return p;
    }

    public IPermissionManager newPermissionManager(String owner) {
        return new PermissionManagerImpl(owner, this);
    }

    public IAuthorizationPrincipal newPrincipal(String key, Class type) {
        Tuple principalKey = new Tuple((Object)key, (Object)type);
        Element element = this.principalCache.get((Serializable)principalKey);
        return (IAuthorizationPrincipal)element.getObjectValue();
    }

    public IAuthorizationPrincipal newPrincipal(IGroupMember groupMember) throws GroupsException {
        String key = groupMember.getKey();
        Class type = groupMember.getType();
        this.logger.debug("AuthorizationImpl.newPrincipal(): for {} ({})", (Object)type, (Object)key);
        return this.newPrincipal(key, type);
    }

    private IAuthorizationPrincipal primNewPrincipal(String key, Class type) {
        return new AuthorizationPrincipalImpl(key, type, (IAuthorizationService)this);
    }

    public IUpdatingPermissionManager newUpdatingPermissionManager(String owner) {
        return new UpdatingPermissionManagerImpl(owner, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal) throws AuthorizationException {
        if (!this.cachePermissions) {
            return this.getUncachedPermissionsForPrincipal(principal, null, null, null);
        }
        IPermissionSet ps = null;
        ps = this.cacheGet(principal);
        if (ps == null) {
            IAuthorizationPrincipal iAuthorizationPrincipal = principal;
            synchronized (iAuthorizationPrincipal) {
                ps = this.cacheGet(principal);
                if (ps == null) {
                    IPermission[] permissions = this.getUncachedPermissionsForPrincipal(principal, null, null, null);
                    ps = new PermissionSetImpl(permissions, principal);
                    this.cacheAdd(ps);
                }
            }
        }
        return ps.getPermissions();
    }

    private IPermission[] primGetPermissionsForPrincipal(IAuthorizationPrincipal principal, String owner, String activity, String target) throws AuthorizationException {
        Set<String> containingGroups;
        IPermission[] perms = this.primGetPermissionsForPrincipal(principal);
        if (owner == null && activity == null && target == null) {
            return perms;
        }
        if (perms.length == 0) {
            return perms;
        }
        if (target != null) {
            Element element = this.entityParentsCache.get((Serializable)((Object)target));
            if (element != null) {
                containingGroups = (Set)element.getObjectValue();
            } else {
                containingGroups = new HashSet();
                if (!("ALL_CATEGORIES".equals(target) || "ALL_GROUPS".equals(target) || "ALL_PORTLETS".equals(target) || "ALL".equals(target))) {
                    IPermissionActivity permissionActivity;
                    boolean checkTargetForContainingGroups = true;
                    if (owner != null && activity != null && this.nonEntityPermissionTargetProviders.contains((permissionActivity = this.permissionOwner.getPermissionActivity(owner, activity)).getTargetProviderKey())) {
                        checkTargetForContainingGroups = false;
                    }
                    if (checkTargetForContainingGroups) {
                        this.logger.debug("Target '{}' is an entity. Checking for group or groups containing entity", (Object)target);
                        IEntityGroup targetEntity = GroupService.findGroup((String)target);
                        if (targetEntity == null) {
                            targetEntity = target.startsWith("PORTLET_ID.") ? GroupService.getGroupMember((String)target.replace("PORTLET_ID.", ""), IPortletDefinition.class) : GroupService.getGroupMember((String)target, IPerson.class);
                        }
                        if (targetEntity != null) {
                            for (IEntityGroup ancestor : targetEntity.getAncestorGroups()) {
                                containingGroups.add(ancestor.getKey());
                            }
                        }
                    }
                }
                this.entityParentsCache.put(new Element((Object)target, containingGroups));
            }
        } else {
            containingGroups = new HashSet();
        }
        ArrayList<IPermission> al = new ArrayList<IPermission>(perms.length);
        for (int i = 0; i < perms.length; ++i) {
            String permissionTarget = perms[i].getTarget();
            if (owner != null && !owner.equals(perms[i].getOwner()) || activity != null && !activity.equals(perms[i].getActivity()) || target != null && !target.equals(permissionTarget) && !containingGroups.contains(permissionTarget)) continue;
            al.add(perms[i]);
        }
        this.logger.trace("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: {} owner: {} activity: {} target: {} : permissions retrieved: {}", new Object[]{principal, owner, activity, target, al});
        this.logger.debug("AuthorizationImpl.primGetPermissionsForPrincipal(): Principal: {} owner: {} activity: {} target: {} : number of permissions retrieved: {}", new Object[]{principal, owner, activity, target, al.size()});
        return al.toArray(new IPermission[al.size()]);
    }

    private IPermission[] primRetrievePermissions(String owner, String principal, String activity, String target) throws AuthorizationException {
        return this.getPermissionStore().select(owner, principal, activity, target, null);
    }

    private void removeFromPermissionsCache(IAuthorizationPrincipal[] principals) throws AuthorizationException {
        for (int i = 0; i < principals.length; ++i) {
            this.cacheRemove(principals[i]);
        }
    }

    private void removeFromPermissionsCache(IPermission[] permissions) throws AuthorizationException {
        IAuthorizationPrincipal[] principals = this.getPrincipalsFromPermissions(permissions);
        this.removeFromPermissionsCache(principals);
    }

    public void removePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().delete(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }

    public void updatePermissions(IPermission[] permissions) throws AuthorizationException {
        if (permissions.length > 0) {
            this.getPermissionStore().update(permissions);
            if (this.cachePermissions) {
                this.removeFromPermissionsCache(permissions);
            }
        }
    }
}

