/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.permission.target;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.PermissionTargetImpl;
import org.apereo.services.persondir.IPersonAttributeDao;

public class UserAttributesTargetProviderImpl
implements IPermissionTargetProvider {
    private IPersonAttributeDao personAttributeDao;

    public void setPersonAttributeDao(IPersonAttributeDao personLookupDao) {
        this.personAttributeDao = personLookupDao;
    }

    @Override
    public IPermissionTarget getTarget(String key) {
        return new PermissionTargetImpl(key, key, IPermissionTarget.TargetType.USER_ATTRIBUTE);
    }

    @Override
    public Collection<IPermissionTarget> searchTargets(String term) {
        term = term.toLowerCase();
        Set attributes = this.personAttributeDao.getAvailableQueryAttributes();
        ArrayList<IPermissionTarget> matches = new ArrayList<IPermissionTarget>();
        for (String attribute : attributes) {
            if (!attribute.toLowerCase().contains(term)) continue;
            matches.add(new PermissionTargetImpl(attribute, attribute, IPermissionTarget.TargetType.USER_ATTRIBUTE));
        }
        return matches;
    }
}

