/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.permission.target;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apereo.portal.layout.dlm.remoting.IGroupListHelper;
import org.apereo.portal.layout.dlm.remoting.JsonEntityBean;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.PermissionTargetImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityTargetProviderImpl
implements IPermissionTargetProvider,
Serializable {
    private static final IPermissionTarget ALL_CATEGORIES_TARGET = new PermissionTargetImpl("ALL_CATEGORIES", "ALL_CATEGORIES", IPermissionTarget.TargetType.CATEGORY);
    private static final IPermissionTarget ALL_GROUPS_TARGET = new PermissionTargetImpl("ALL_GROUPS", "ALL_GROUPS", IPermissionTarget.TargetType.GROUP);
    private static final IPermissionTarget ALL_PORTLETS_TARGET = new PermissionTargetImpl("ALL_PORTLETS", "ALL_PORTLETS", IPermissionTarget.TargetType.PORTLET);
    private static final long serialVersionUID = 1L;
    private Set<IPermissionTarget.TargetType> allowedTargetTypes = new HashSet<IPermissionTarget.TargetType>();
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private transient IGroupListHelper groupListHelper;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper helper) {
        this.groupListHelper = helper;
    }

    public EntityTargetProviderImpl(Set<String> targetTypeNames) {
        Iterator<String> iterator = targetTypeNames.iterator();
        block12: while (iterator.hasNext()) {
            String name;
            switch (name = iterator.next()) {
                case "person": {
                    this.allowedTargetTypes.add(IPermissionTarget.TargetType.PERSON);
                    continue block12;
                }
                case "group": {
                    this.allowedTargetTypes.add(IPermissionTarget.TargetType.GROUP);
                    continue block12;
                }
                case "portlet": {
                    this.allowedTargetTypes.add(IPermissionTarget.TargetType.PORTLET);
                    continue block12;
                }
                case "category": {
                    this.allowedTargetTypes.add(IPermissionTarget.TargetType.CATEGORY);
                    continue block12;
                }
            }
            String msg = "Unrecognized targetTypeName:  " + name;
            throw new RuntimeException(msg);
        }
    }

    @Override
    public IPermissionTarget getTarget(String key) {
        switch (key) {
            case "ALL_CATEGORIES": {
                return ALL_CATEGORIES_TARGET;
            }
            case "ALL_PORTLETS": {
                return ALL_PORTLETS_TARGET;
            }
            case "ALL_GROUPS": {
                return ALL_GROUPS_TARGET;
            }
        }
        for (IPermissionTarget.TargetType targetType : this.allowedTargetTypes) {
            JsonEntityBean entity = this.groupListHelper.getEntity(targetType.toString(), key, false);
            if (entity == null) continue;
            PermissionTargetImpl target = new PermissionTargetImpl(entity.getId(), entity.getName(), targetType);
            return target;
        }
        return null;
    }

    @Override
    public Collection<IPermissionTarget> searchTargets(String term) {
        HashSet<IPermissionTarget> matching = new HashSet<IPermissionTarget>();
        for (IPermissionTarget.TargetType targetType : this.allowedTargetTypes) {
            Set entities = this.groupListHelper.search(targetType.toString(), term);
            for (JsonEntityBean entity : entities) {
                PermissionTargetImpl target = new PermissionTargetImpl(entity.getId(), entity.getName(), targetType);
                matching.add(target);
            }
        }
        if ("ALL_CATEGORIES".contains(term)) {
            matching.add(ALL_CATEGORIES_TARGET);
        } else if ("ALL_PORTLETS".contains(term)) {
            matching.add(ALL_PORTLETS_TARGET);
        } else if ("ALL_GROUPS".contains(term)) {
            matching.add(ALL_GROUPS_TARGET);
        }
        return matching;
    }
}

