/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.permission.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apereo.portal.jpa.BaseJpaDao;
import org.apereo.portal.jpa.BasePortalJpaDao;
import org.apereo.portal.jpa.OpenEntityManager;
import org.apereo.portal.permission.IPermissionActivity;
import org.apereo.portal.permission.IPermissionOwner;
import org.apereo.portal.permission.dao.IPermissionOwnerDao;
import org.apereo.portal.permission.dao.jpa.PermissionActivityImpl;
import org.apereo.portal.permission.dao.jpa.PermissionOwnerImpl;
import org.apereo.portal.permission.dao.jpa.PermissionOwnerImpl_;
import org.springframework.stereotype.Repository;

@Repository(value="permissionOwnerDao")
public class JpaPermissionOwnerDao
extends BasePortalJpaDao
implements IPermissionOwnerDao {
    private CriteriaQuery<PermissionOwnerImpl> findAllPermissionOwners;

    public void afterPropertiesSet() throws Exception {
        this.findAllPermissionOwners = this.createCriteriaQuery((Function)new Function<CriteriaBuilder, CriteriaQuery<PermissionOwnerImpl>>(){

            public CriteriaQuery<PermissionOwnerImpl> apply(CriteriaBuilder cb) {
                CriteriaQuery criteriaQuery = cb.createQuery(PermissionOwnerImpl.class);
                Root ownerRoot = criteriaQuery.from(PermissionOwnerImpl.class);
                criteriaQuery.select((Selection)ownerRoot);
                ownerRoot.fetch(PermissionOwnerImpl_.activities, JoinType.LEFT);
                return criteriaQuery;
            }
        });
    }

    @Override
    public List<IPermissionOwner> getAllPermissionOwners() {
        TypedQuery query = this.createCachedQuery(this.findAllPermissionOwners);
        List resultList = query.getResultList();
        return new ArrayList<IPermissionOwner>(new LinkedHashSet(resultList));
    }

    @Override
    @BasePortalJpaDao.PortalTransactional
    public IPermissionOwner getOrCreatePermissionOwner(String name, String fname) {
        IPermissionOwner owner = this.getPermissionOwner(fname);
        if (owner == null) {
            owner = new PermissionOwnerImpl(name, fname);
            this.getEntityManager().persist((Object)owner);
        }
        return owner;
    }

    @Override
    public IPermissionOwner getPermissionOwner(long id) {
        return (IPermissionOwner)this.getEntityManager().find(PermissionOwnerImpl.class, (Object)id);
    }

    @Override
    @OpenEntityManager(unitName="PortalDb")
    public IPermissionOwner getPermissionOwner(String fname) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(PermissionOwnerImpl.class);
        query.using(PermissionOwnerImpl_.fname, (Object)fname);
        return (IPermissionOwner)query.load();
    }

    @Override
    @BasePortalJpaDao.PortalTransactional
    public IPermissionOwner saveOwner(IPermissionOwner owner) {
        this.getEntityManager().persist((Object)owner);
        return owner;
    }

    @Override
    @BasePortalJpaDao.PortalTransactional
    public IPermissionActivity getOrCreatePermissionActivity(IPermissionOwner owner, String name, String fname, String targetProviderKey) {
        IPermissionActivity activity = this.getPermissionActivity(owner.getId(), fname);
        if (activity == null) {
            activity = new PermissionActivityImpl(name, fname, targetProviderKey);
            owner.getActivities().add(activity);
        }
        return activity;
    }

    @Override
    public IPermissionActivity getPermissionActivity(long id) {
        return (IPermissionActivity)this.getEntityManager().find(PermissionActivityImpl.class, (Object)id);
    }

    @Override
    public IPermissionActivity getPermissionActivity(long ownerId, String activityFname) {
        IPermissionOwner permissionOwner = this.getPermissionOwner(ownerId);
        return this.findActivity(permissionOwner, activityFname);
    }

    @Override
    @BasePortalJpaDao.PortalTransactionalReadOnly
    public IPermissionActivity getPermissionActivity(String ownerFname, String activityFname) {
        IPermissionOwner permissionOwner = this.getPermissionOwner(ownerFname);
        return this.findActivity(permissionOwner, activityFname);
    }

    @Override
    @BasePortalJpaDao.PortalTransactional
    public IPermissionActivity savePermissionActivity(IPermissionActivity activity) {
        this.getEntityManager().persist((Object)activity);
        return activity;
    }

    protected IPermissionActivity findActivity(IPermissionOwner permissionOwner, String activityFname) {
        if (permissionOwner == null) {
            return null;
        }
        Set activities = permissionOwner.getActivities();
        for (IPermissionActivity permissionActivity : activities) {
            if (!activityFname.equals(permissionActivity.getFname())) continue;
            return permissionActivity;
        }
        return null;
    }
}

