/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.security.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apereo.portal.EntityIdentifier;
import org.apereo.portal.groups.IEntityGroup;
import org.apereo.portal.groups.IGroupMember;
import org.apereo.portal.permission.IPermissionActivity;
import org.apereo.portal.permission.IPermissionOwner;
import org.apereo.portal.permission.dao.IPermissionOwnerDao;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.IPermissionTargetProviderRegistry;
import org.apereo.portal.portlet.om.IPortletDefinition;
import org.apereo.portal.portlet.registry.IPortletDefinitionRegistry;
import org.apereo.portal.security.IAuthorizationPrincipal;
import org.apereo.portal.security.IAuthorizationService;
import org.apereo.portal.security.IPerson;
import org.apereo.portal.security.PermissionHelper;
import org.apereo.portal.security.provider.AnyUnblockedGrantPermissionPolicy;
import org.apereo.portal.services.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class PortletPermissionsCachePrimer {
    @Autowired
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    @Autowired
    private IPermissionOwnerDao permissionOwnerDao;
    @Autowired
    private IPermissionTargetProviderRegistry targetProviderRegistry;
    @Autowired
    private IAuthorizationService authorizationService;
    @Autowired
    private AnyUnblockedGrantPermissionPolicy policy;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadPoolExecutor executor;
    private Map<String, Set<String>> permissionsMap;

    @Required
    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Required
    public void setPermissionsMap(Map<String, Set<String>> permissionsMap) {
        this.permissionsMap = Collections.unmodifiableMap(permissionsMap);
    }

    public void primeCache() {
        if (this.executor.getActiveCount() != 0) {
            this.log.warn("Skipping this run becasue there are active threads in the executor, signifying the previous run is not complete");
            return;
        }
        this.log.info("STARTING PortletPermissionsCachePrimer.primeCache()...");
        long timestamp = System.currentTimeMillis();
        HashMap<NodeWalker, Future<NodeWalkerReport>> futures = new HashMap<NodeWalker, Future<NodeWalkerReport>>();
        IEntityGroup rootGroup = GroupService.getRootGroup(IPerson.class);
        for (Map.Entry<String, Set<String>> y : this.permissionsMap.entrySet()) {
            IPermissionOwner owner = this.permissionOwnerDao.getPermissionOwner(y.getKey());
            for (String s : y.getValue()) {
                IPermissionActivity activity = this.permissionOwnerDao.getPermissionActivity(y.getKey(), s);
                IPermissionTargetProvider targetProvider = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey());
                NodeWalker walker = new NodeWalker(rootGroup, owner, activity, targetProvider);
                Future<NodeWalkerReport> future = this.executor.submit(walker);
                futures.put(walker, future);
            }
        }
        int totalCombinations = 0;
        for (Map.Entry y : futures.entrySet()) {
            try {
                NodeWalkerReport report = (NodeWalkerReport)((Future)y.getValue()).get();
                totalCombinations += report.getCombinationCount();
                this.log.debug("NodeWalker '{}' processed {} combinations in {}ms", new Object[]{y.getKey(), report.getCombinationCount(), report.getDuration()});
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.error("NodeWalker '{}' failed", y.getKey());
            }
        }
        this.log.info("COMPLETED PortletPermissionsCachePrimer.primeCache();  processed {} total combinations in {}ms", (Object)totalCombinations, (Object)Long.toString(System.currentTimeMillis() - timestamp));
    }

    private static final class NodeWalkerReport {
        private int combinationCount;
        private long duration;

        private NodeWalkerReport() {
        }

        public int getCombinationCount() {
            return this.combinationCount;
        }

        public void incrementCombinationCount() {
            ++this.combinationCount;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }
    }

    private final class NodeWalker
    implements Callable<NodeWalkerReport> {
        final IEntityGroup rootGroup;
        final IPermissionOwner owner;
        final IPermissionActivity activity;
        final IPermissionTargetProvider targetProvider;

        public NodeWalker(IEntityGroup rootGroup, IPermissionOwner owner, IPermissionActivity activity, IPermissionTargetProvider targetProvider) {
            this.rootGroup = rootGroup;
            this.owner = owner;
            this.activity = activity;
            this.targetProvider = targetProvider;
        }

        @Override
        public NodeWalkerReport call() throws Exception {
            NodeWalkerReport rslt = new NodeWalkerReport();
            long timestamp = System.currentTimeMillis();
            this.walk(this.rootGroup, new HashSet<EntityIdentifier>(), rslt);
            rslt.setDuration(System.currentTimeMillis() - timestamp);
            return rslt;
        }

        private void walk(IEntityGroup group, Set<EntityIdentifier> visitedNodes, NodeWalkerReport report) {
            if (visitedNodes.contains(group.getUnderlyingEntityIdentifier())) {
                return;
            }
            visitedNodes.add(group.getUnderlyingEntityIdentifier());
            IAuthorizationPrincipal principal = PortletPermissionsCachePrimer.this.authorizationService.newPrincipal((IGroupMember)group);
            List portletDefinitions = PortletPermissionsCachePrimer.this.portletDefinitionRegistry.getAllPortletDefinitions();
            for (IPortletDefinition pdef : portletDefinitions) {
                String targetString = PermissionHelper.permissionTargetIdForPortletDefinition((IPortletDefinition)pdef);
                IPermissionTarget target = this.targetProvider.getTarget(targetString);
                PortletPermissionsCachePrimer.this.policy.loadInCache(PortletPermissionsCachePrimer.this.authorizationService, principal, this.owner, this.activity, target);
                report.incrementCombinationCount();
            }
            if (group.hasMembers()) {
                Set members = group.getChildren();
                for (IGroupMember member : members) {
                    if (!member.isGroup()) continue;
                    IEntityGroup child = (IEntityGroup)member;
                    this.walk(child, visitedNodes, report);
                }
            }
        }

        public String toString() {
            return "NodeWalker [rootGroup=" + this.rootGroup + ", owner=" + this.owner + ", activity=" + this.activity + "]";
        }
    }
}

