/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.security.provider;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apereo.portal.AuthorizationException;
import org.apereo.portal.groups.GroupsException;
import org.apereo.portal.groups.IGroupMember;
import org.apereo.portal.permission.IPermissionActivity;
import org.apereo.portal.permission.IPermissionOwner;
import org.apereo.portal.permission.dao.IPermissionOwnerDao;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProviderRegistry;
import org.apereo.portal.security.IAuthorizationPrincipal;
import org.apereo.portal.security.IAuthorizationService;
import org.apereo.portal.security.IPermission;
import org.apereo.portal.security.IPermissionPolicy;
import org.apereo.portal.utils.cache.CacheEntryTag;
import org.apereo.portal.utils.cache.CacheKey;
import org.apereo.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="anyUnblockedGrantPermissionPolicy")
public class AnyUnblockedGrantPermissionPolicy
implements IPermissionPolicy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPermissionOwnerDao permissionOwnerDao;
    @Autowired
    private IPermissionTargetProviderRegistry targetProviderRegistry;
    @Autowired
    @Qualifier(value="org.apereo.portal.security.provider.AnyUnblockedGrantPermissionPolicy.HAS_UNBLOCKED_GRANT")
    private Cache hasUnblockedGrantCache;

    public boolean doesPrincipalHavePermission(IAuthorizationService service, IAuthorizationPrincipal principal, IPermissionOwner owner, IPermissionActivity activity, IPermissionTarget target) throws AuthorizationException {
        boolean rslt;
        IPermissionTarget allPermissionsTarget;
        IPermissionOwner allPermissionsOwner;
        if (service == null || principal == null || owner == null || activity == null || target == null) {
            this.log.error("Null argument to AnyUnblockedGrantPermissionPolicy doesPrincipalHavePermission() method should not be possible.  This is indicative of a potentially serious bug in the permissions and authorization infrastructure;  service='{}', principal='{}', owner='{}', activity='{}', target='{}'", new Object[]{service, principal, owner, activity, target, new AuthorizationException("Null argument")});
            return false;
        }
        IPermissionActivity allPermissionsActivity = this.permissionOwnerDao.getPermissionActivity("UP_SYSTEM", "ALL_PERMISSIONS");
        if (!activity.equals(allPermissionsActivity) && this.doesPrincipalHavePermission(service, principal, allPermissionsOwner = this.permissionOwnerDao.getPermissionOwner("UP_SYSTEM"), allPermissionsActivity, allPermissionsTarget = this.targetProviderRegistry.getTargetProvider(allPermissionsActivity.getTargetProviderKey()).getTarget("ALL"))) {
            return true;
        }
        Object collectiveTarget = null;
        switch (target.getTargetType()) {
            case PORTLET: {
                collectiveTarget = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey()).getTarget("ALL_PORTLETS");
                break;
            }
            case CATEGORY: {
                collectiveTarget = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey()).getTarget("ALL_CATEGORIES");
                break;
            }
            case GROUP: {
                collectiveTarget = this.targetProviderRegistry.getTargetProvider(activity.getTargetProviderKey()).getTarget("ALL_GROUPS");
                break;
            }
        }
        if (collectiveTarget != null && !collectiveTarget.equals(target) && this.doesPrincipalHavePermission(service, principal, owner, activity, (IPermissionTarget)collectiveTarget)) {
            return true;
        }
        try {
            HashSet<IGroupMember> seenGroups = new HashSet<IGroupMember>();
            rslt = this.hasUnblockedPathToGrantWithCache(service, principal, owner, activity, target, seenGroups);
        }
        catch (Exception e) {
            this.log.error("Error searching for unblocked path to grant for principal [" + principal + "]", (Throwable)e);
            return false;
        }
        if (this.log.isTraceEnabled()) {
            if (rslt) {
                this.log.trace("Principal '{}' is granted permission to perform activity '{}' on target '{}' under permission owning system '{}' because this principal has an unblocked path to a GRANT.", new Object[]{principal, activity.getFname(), target.getKey(), owner.getFname()});
            } else {
                this.log.trace("Principal '{}' is denied permission to perform activity '{}' on target '{}' under permission owning system '{}' because this principal does not have an unblocked path to a GRANT.", new Object[]{principal, activity.getFname(), target.getKey(), owner.getFname()});
            }
        }
        return rslt;
    }

    public void loadInCache(IAuthorizationService service, IAuthorizationPrincipal principal, IPermissionOwner owner, IPermissionActivity activity, IPermissionTarget target) {
        HashSet<IGroupMember> seenGroups = new HashSet<IGroupMember>();
        CacheKey cacheKey = this.getCacheKey(principal, owner, activity, target);
        boolean answer = this.hasUnblockedPathToGrant(service, principal, owner, activity, target, seenGroups);
        Element element = new Element((Serializable)cacheKey, (Serializable)Boolean.valueOf(answer));
        this.hasUnblockedGrantCache.put(element);
    }

    private boolean hasUnblockedPathToGrantWithCache(IAuthorizationService service, IAuthorizationPrincipal principal, IPermissionOwner owner, IPermissionActivity activity, IPermissionTarget target, Set<IGroupMember> seenGroups) throws GroupsException {
        CacheKey cacheKey = this.getCacheKey(principal, owner, activity, target);
        Element element = this.hasUnblockedGrantCache.get((Serializable)cacheKey);
        if (element == null) {
            boolean answer = this.hasUnblockedPathToGrant(service, principal, owner, activity, target, seenGroups);
            element = new Element((Serializable)cacheKey, (Serializable)Boolean.valueOf(answer));
            this.hasUnblockedGrantCache.put(element);
        }
        return (Boolean)element.getObjectValue();
    }

    private boolean hasUnblockedPathToGrant(IAuthorizationService service, IAuthorizationPrincipal principal, IPermissionOwner owner, IPermissionActivity activity, IPermissionTarget target, Set<IGroupMember> seenGroups) throws GroupsException {
        IPermission[] permissions;
        Set<IPermission> activePermissions;
        boolean denyExists;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Searching for unblocked path to GRANT for principal '{}' to '{}' on target '{}' having already checked:  {}", new Object[]{principal.getKey(), activity.getFname(), target.getKey(), seenGroups});
        }
        if (denyExists = this.containsType(activePermissions = this.removeInactivePermissions(permissions = service.getPermissionsForPrincipal(principal, owner.getFname(), activity.getFname(), target.getKey())), "DENY")) {
            return false;
        }
        boolean grantExists = this.containsType(activePermissions, "GRANT");
        if (grantExists) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Found unblocked path to this permission set including a GRANT:  {}", activePermissions);
            }
            return true;
        }
        IGroupMember principalAsGroupMember = service.getGroupMember(principal);
        if (seenGroups.contains(principalAsGroupMember)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Declining to re-examine principal '{}' for permission to '{}' on '{}' because this group is among already checked groups:  {}", new Object[]{principal.getKey(), activity.getFname(), target.getKey(), seenGroups});
            }
            return false;
        }
        seenGroups.add(principalAsGroupMember);
        Set immediatelyContainingGroups = principalAsGroupMember.getParentGroups();
        for (IGroupMember parentGroup : immediatelyContainingGroups) {
            try {
                IAuthorizationPrincipal parentPrincipal;
                boolean parentHasUnblockedPathToGrant;
                if (parentGroup == null || !(parentHasUnblockedPathToGrant = this.hasUnblockedPathToGrantWithCache(service, parentPrincipal = service.newPrincipal(parentGroup), owner, activity, target, seenGroups))) continue;
                return true;
            }
            catch (Exception e) {
                this.log.error("Error evaluating permissions of parent group [" + parentGroup + "]", (Throwable)e);
            }
        }
        return false;
    }

    private Set<IPermission> removeInactivePermissions(IPermission[] perms) {
        Date now = new Date();
        HashSet<IPermission> rslt = new HashSet<IPermission>(1);
        for (int i = 0; i < perms.length; ++i) {
            IPermission p = perms[i];
            if (p.getEffective() != null && p.getEffective().after(now) || p.getExpires() != null && !p.getExpires().after(now)) continue;
            rslt.add(p);
        }
        return rslt;
    }

    private boolean containsType(Set<IPermission> permissions, String soughtType) {
        if (permissions == null) {
            throw new IllegalArgumentException("Cannot check null set for contents.");
        }
        if (soughtType == null) {
            throw new IllegalArgumentException("Cannot search for type null.");
        }
        boolean rslt = false;
        for (IPermission p : permissions) {
            if (!soughtType.equals(p.getType())) continue;
            rslt = true;
        }
        return rslt;
    }

    protected CacheKey getCacheKey(IAuthorizationPrincipal principal, IPermissionOwner owner, IPermissionActivity activity, IPermissionTarget target) {
        CacheKey rslt = principal.isGroup() ? CacheKey.build((String)AnyUnblockedGrantPermissionPolicy.class.getName(), (Serializable[])new Serializable[]{principal.getPrincipalString(), owner.getFname(), activity.getFname(), target.getKey()}) : CacheKey.buildTagged((String)AnyUnblockedGrantPermissionPolicy.class.getName(), (CacheEntryTag)UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)principal.getKey()), (Serializable[])new Serializable[]{principal.getPrincipalString(), owner.getFname(), activity.getFname(), target.getKey()});
        return rslt;
    }
}

