/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.permission.target;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.PermissionTargetImpl;
import org.apereo.portal.portlet.om.IPortletType;
import org.apereo.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.springframework.beans.factory.annotation.Autowired;

public class PortletTypeTargetProviderImpl
implements IPermissionTargetProvider {
    public static final IPermissionTarget ALL_PORTLET_TYPES_TARGET = new PermissionTargetImpl("ALL_PORTLET_TYPES", "ALL_PORTLET_TYPES", IPermissionTarget.TargetType.PORTLET_TYPE);
    @Autowired
    private IChannelPublishingDefinitionDao channelPublishingDefinitionDao;

    @Override
    public IPermissionTarget getTarget(String key) {
        Validate.notBlank((CharSequence)key, (String)"Argument 'key' cannot be blank", (Object[])new Object[0]);
        IPermissionTarget rslt = null;
        if (key.equals("ALL_PORTLET_TYPES")) {
            rslt = ALL_PORTLET_TYPES_TARGET;
        } else {
            Map cpds = this.channelPublishingDefinitionDao.getChannelPublishingDefinitions();
            for (Map.Entry y : cpds.entrySet()) {
                if (!((IPortletType)y.getKey()).getName().equals(key)) continue;
                rslt = new PermissionTargetImpl(((IPortletType)y.getKey()).getName(), ((IPortletType)y.getKey()).getName(), IPermissionTarget.TargetType.PORTLET_TYPE);
            }
        }
        return rslt;
    }

    @Override
    public Collection<IPermissionTarget> searchTargets(String term) {
        Validate.notBlank((CharSequence)term, (String)"Argument 'term' cannot be blank", (Object[])new Object[0]);
        HashSet<IPermissionTarget> rslt = new HashSet<IPermissionTarget>();
        String lowerTerm = term.toLowerCase();
        if ("ALL_PORTLET_TYPES".toLowerCase().contains(lowerTerm)) {
            rslt.add(ALL_PORTLET_TYPES_TARGET);
        }
        Map cpds = this.channelPublishingDefinitionDao.getChannelPublishingDefinitions();
        for (Map.Entry y : cpds.entrySet()) {
            if (!((IPortletType)y.getKey()).getName().toLowerCase().contains(lowerTerm)) continue;
            PermissionTargetImpl target = new PermissionTargetImpl(((IPortletType)y.getKey()).getName(), ((IPortletType)y.getKey()).getName(), IPermissionTarget.TargetType.PORTLET_TYPE);
            rslt.add(target);
        }
        return rslt;
    }
}

