/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.permission.target;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.portal.io.xml.IPortalDataHandlerService;
import org.apereo.portal.io.xml.IPortalDataType;
import org.apereo.portal.permission.target.IPermissionTarget;
import org.apereo.portal.permission.target.IPermissionTargetProvider;
import org.apereo.portal.permission.target.PermissionTargetImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class PortalDataTypeTargetProviderImpl
implements IPermissionTargetProvider {
    private Map<String, IPermissionTarget> targetMap = new HashMap<String, IPermissionTarget>();
    @Autowired
    private IPortalDataHandlerService portalDataHandlerService;

    @PostConstruct
    public void init() {
        Iterable dataTypes = this.portalDataHandlerService.getExportPortalDataTypes();
        for (IPortalDataType type : dataTypes) {
            String typeId = type.getTypeId();
            this.targetMap.put(typeId, new PermissionTargetImpl(typeId, typeId, IPermissionTarget.TargetType.DATA_TYPE));
        }
    }

    @Override
    public IPermissionTarget getTarget(String key) {
        return this.targetMap.get(key);
    }

    @Override
    public Collection<IPermissionTarget> searchTargets(String term) {
        term = term.toLowerCase();
        ArrayList<IPermissionTarget> matching = new ArrayList<IPermissionTarget>();
        for (IPermissionTarget target : this.targetMap.values()) {
            if (!target.getKey().toLowerCase().contains(term) && !target.getName().toLowerCase().contains(term)) continue;
            matching.add(target);
        }
        return matching;
    }
}

