/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.portal.health;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apereo.portal.health.IHealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HealthCheckController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private List<? extends IHealthChecker> checkers;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public Map<String, Map<String, Object>> healthCheck(@RequestParam(required=false) List<String> detail) throws RuntimeException {
        Map<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        if (detail == null || detail.isEmpty()) {
            this.logger.debug("Doing a health check...");
        } else {
            List checkerIDs = detail.parallelStream().map(String::toUpperCase).collect(Collectors.toList());
            map = checkerIDs.contains("ALL") ? this.checkers.parallelStream().collect(Collectors.toMap(IHealthChecker::getName, IHealthChecker::runCheck)) : this.checkers.parallelStream().filter(c -> checkerIDs.contains(c.getDetailIdentifier().toUpperCase())).collect(Collectors.toMap(IHealthChecker::getName, IHealthChecker::runCheck));
            map.put("Time", this.getTime());
        }
        return map;
    }

    Map<String, Object> getTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long ms = System.currentTimeMillis();
        map.put("Current Time (ms)", ms);
        String time = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now());
        map.put("Current Time", time);
        return map;
    }
}

