<%--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

--%>

<div id="content">
	<h1>Welcome to OpenRegistry!</h1>
	<div id="login">
		<p>Please <a href="main.htm">Login</a> with your NetID and Password.</p>
	</div>
	<div id="blurb">
		<h2>What is OpenRegistry?</h2>
		<p>OpenRegistry is an OpenSource Identity Management System (IDMS). It's a place for data about people affiliated with your organization.</p>

		<h2>Core Functionality</h2>
		<ul>
			<li>Interfaces for web, batch, and real-time data transfer</li>
			<li>Identity data store</li>
			<li>Identity reconciliation from multiple systems of record</li>
			<li>Identifier assignment for new, unique individuals</li>
			<li>Additional Functionality</li>
			<li>Data beyond Persons: Groups, Courses, Credentials, Accounts</li>
			<li>Business Rule based data transformations</li>
			<li>More than just a Registry, some periphery too</li>
			<li>Directory Builder</li>
			<li>Provisioning and Deprovisioning</li>
		</ul>
		<br />
		<h2>Why OpenRegistry?</h2>
		<ul>
			<li>"Off the shelf" solutions usually end up requiring significant customizations and integration work and/or solve only a portion of an institution's needs</li>
			<li>Lots of institutions still rolling their own</li>
			<li>Combined institutional efforts better leverage scant resources and allow for learning from others' experience (eg: Sakai, uPortal, CAS, Shibboleth, Kuali)</li>
			<li>OpenRegistry is tailored to the needs of higher ed</li>
		</ul>
		<br />
		<h2>How do I get involved or find out more?</h2>
		<ul>
			<li>Check out our <a href="http://www.ja-sig.org/wiki/display/OR/Home">wiki</a>!</li>
			<li>Subscribe to the <a href="http://www.ja-sig.org/wiki/display/JSG/OpenRegistry+Project+Lists">mailing lists</a>!</li>
			<li>File bugs and feature requests in our <a href="http://www.ja-sig.org/issues/browse/OR">issue tracker</a>.</li>
			<li>Browse the <a href="http://www.ja-sig.org/wiki/display/ORUM/Source+Control">source code</a>.</li>
		</ul>
	</div>
</div>
<div class="or-form-name">Form: Home</div>
