/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources.activation;

import com.sun.jersey.api.NotFoundException;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.openregistry.core.domain.ActivationKey;
import org.openregistry.core.domain.LockingException;
import org.openregistry.core.domain.PersonNotFoundException;
import org.openregistry.core.service.ActivationService;
import org.openregistry.core.web.resources.config.DefaultLockExtractor;
import org.openregistry.core.web.resources.config.LockExtractor;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="activationKeyProcessorResource")
@Singleton
@Path(value="/people/{personIdType}/{personId}/activation/{activationKey}")
public final class ActivationKeyProcessorResource {
    private final ActivationService activationService;
    @Autowired(required=false)
    private LockExtractor lockExtractor = new DefaultLockExtractor();

    @Inject
    public ActivationKeyProcessorResource(ActivationService activationService) {
        this.activationService = activationService;
    }

    public void setLockExtractor(LockExtractor lockExtractor) {
        this.lockExtractor = lockExtractor;
    }

    @DELETE
    public Response invalidateActivationKey(@PathParam(value="personIdType") String personIdType, @PathParam(value="personId") String personId, @PathParam(value="activationKey") String activationKey, @Context SecurityContext securityContext) {
        try {
            this.activationService.invalidateActivationKey(personIdType, personId, activationKey, this.lockExtractor.extract(securityContext.getUserPrincipal(), null));
        }
        catch (IllegalStateException illegalStateException) {
            return Response.status((int)409).entity((Object)String.format("The activation key [%s] is not valid.", activationKey)).type("text/plain").build();
        }
        catch (PersonNotFoundException personNotFoundException) {
            throw new NotFoundException(String.format("The person resource identified by /people/%s/%s URI does not exist", personIdType, personId));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotFoundException(String.format("The person resource identified by /people/%s/%s/%s URI does not exist", personIdType, personId, activationKey));
        }
        catch (LockingException e) {
            return Response.status((int)409).entity((Object)e.getMessage()).type("text/plain").build();
        }
        return null;
    }

    @GET
    public Response verifyActivationKey(@PathParam(value="personIdType") String personIdType, @PathParam(value="personId") String personId, @PathParam(value="activationKey") String activationKey, @Context SecurityContext securityContext) {
        try {
            ActivationKey ak = this.activationService.getActivationKey(personIdType, personId, activationKey, this.lockExtractor.extract(securityContext.getUserPrincipal(), null));
            if (ak == null) {
                throw new NotFoundException(String.format("The activation key [%s] does not exist", activationKey));
            }
            if (ak.isNotYetValid()) {
                return Response.status((int)409).entity((Object)String.format("The activation key [%s] is not yet valid for use", activationKey)).type("text/plain").build();
            }
            if (ak.isExpired()) {
                return Response.status((int)410).entity((Object)String.format("The activation key [%s] has expired", activationKey)).type("text/plain").build();
            }
        }
        catch (PersonNotFoundException personNotFoundException) {
            throw new NotFoundException(String.format("The person resource identified by /people/%s/%s URI does not exist", personIdType, personId));
        }
        catch (LockingException e) {
            return Response.status((int)409).entity((Object)e.getMessage()).type("text/plain").build();
        }
        return null;
    }
}

