/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources.activation;

import com.sun.jersey.api.NotFoundException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openregistry.core.domain.PersonNotFoundException;
import org.openregistry.core.service.ActivationService;

@Named(value="activationkeyFactoryResource")
@Singleton
@Path(value="/people/{personIdType}/{personId}/activation")
public final class ActivationKeyFactoryResource {
    private final ActivationService activationService;
    @Context
    UriInfo uriInfo;

    @Inject
    public ActivationKeyFactoryResource(ActivationService activationService) {
        this.activationService = activationService;
    }

    @POST
    public Response generateNewActivationKey(@PathParam(value="personIdType") String personIdType, @PathParam(value="personId") String personId) {
        try {
            String activationKey = this.activationService.generateActivationKey(personIdType, personId).asString();
            return Response.created((URI)this.buildActivationProcessorResourceUri(activationKey)).build();
        }
        catch (PersonNotFoundException personNotFoundException) {
            throw new NotFoundException(String.format("The person resource identified by /people/%s/%s URI does not exist", personIdType, personId));
        }
    }

    private URI buildActivationProcessorResourceUri(String activationKey) {
        return this.uriInfo.getAbsolutePathBuilder().path(activationKey).build(new Object[0]);
    }
}

