/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources;

import com.sun.jersey.api.NotFoundException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openregistry.core.domain.Address;
import org.openregistry.core.domain.Country;
import org.openregistry.core.domain.EmailAddress;
import org.openregistry.core.domain.OrganizationalUnit;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.PersonNotFoundException;
import org.openregistry.core.domain.Phone;
import org.openregistry.core.domain.Type;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.domain.sor.SorRole;
import org.openregistry.core.domain.sor.SystemOfRecord;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.utils.ValidationUtils;
import org.openregistry.core.web.resources.representations.ErrorsResponseRepresentation;
import org.openregistry.core.web.resources.representations.RoleRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
@Path(value="/sor/{sorSourceId}/people/{sorPersonId}/roles")
public class SystemOfRecordRolesResource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Context
    UriInfo uriInfo;
    private final PersonService personService;
    private final ReferenceRepository referenceRepository;
    private final Integer DEFAULT_PHONE_LINE_ORDER = new Integer(1);
    @Resource
    private String preferredPersonIdentifierType;

    @Inject
    public SystemOfRecordRolesResource(PersonService personService, ReferenceRepository referenceRepository) {
        this.personService = personService;
        this.referenceRepository = referenceRepository;
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response processIncomingRole(@PathParam(value="sorSourceId") String sorSourceId, @PathParam(value="sorPersonId") String sorPersonId, RoleRepresentation roleRepresentation) {
        SorRole sorRole;
        SorPerson sorPerson = (SorPerson)this.findPersonAndRoleOrThrowNotFoundException(sorSourceId, sorPersonId, null).get("person");
        ServiceExecutionResult result = this.personService.validateAndSaveRoleForSorPerson(sorPerson, sorRole = this.buildSorRoleFrom(sorPerson, roleRepresentation));
        if (!result.getValidationErrors().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(ValidationUtils.buildValidationErrorsResponseAsList((Set)result.getValidationErrors()))).type("application/xml").build();
        }
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(((SorRole)result.getTargetObject()).getSorId()).build(new Object[0])).build();
    }

    @PUT
    @Path(value="{sorRoleId}")
    @Consumes(value={"application/xml"})
    public Response updateIncomingRole(@PathParam(value="sorSourceId") String sorSourceId, @PathParam(value="sorPersonId") String sorPersonId, @PathParam(value="sorRoleId") String sorRoleId, RoleRepresentation roleRepresentation) {
        Map pair = this.findPersonAndRoleOrThrowNotFoundException(sorSourceId, sorPersonId, sorRoleId);
        SorRole sorRole = (SorRole)pair.get("role");
        SorPerson sorPerson = (SorPerson)pair.get("person");
        this.updateSorRoleWithIncomingData(sorPerson, sorRole, roleRepresentation);
        ServiceExecutionResult result = this.personService.updateSorRole(sorPerson, sorRole);
        if (!result.getValidationErrors().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(ValidationUtils.buildValidationErrorsResponseAsList((Set)result.getValidationErrors()))).type("application/xml").build();
        }
        return null;
    }

    @DELETE
    @Path(value="{sorRoleId}")
    public Response deleteRole(@PathParam(value="sorSourceId") String sorSourceId, @PathParam(value="sorPersonId") String sorPersonId, @PathParam(value="sorRoleId") String sorRoleId, @QueryParam(value="mistake") @DefaultValue(value="false") boolean mistake, @QueryParam(value="terminationType") @DefaultValue(value="UNSPECIFIED") String terminationType) {
        Map personAndRole = this.findPersonAndRoleOrThrowNotFoundException(sorSourceId, sorPersonId, sorRoleId);
        SorPerson sorPerson = (SorPerson)personAndRole.get("person");
        SorRole sorRole = (SorRole)personAndRole.get("role");
        try {
            if (!this.personService.deleteSystemOfRecordRole(sorPerson, sorRole, mistake, terminationType)) {
                throw new WebApplicationException((Throwable)new RuntimeException(String.format("Unable to Delete SorRole for SoR [ %s ] with ID [ %s ] and Role ID [ %s ]", sorSourceId, sorPersonId, sorRoleId)), 500);
            }
            this.logger.debug("The SOR Person role has been successfully DELETEd");
            return null;
        }
        catch (PersonNotFoundException personNotFoundException) {
            throw new NotFoundException(String.format("The system of record role resource identified by /sor/%s/people/%s/%s URI does not exist", sorSourceId, sorPersonId, sorRoleId));
        }
    }

    private Map<String, Object> findPersonAndRoleOrThrowNotFoundException(String sorSourceId, String sorPersonId, String sorRoleId) {
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        SorPerson sorPerson = this.personService.findBySorIdentifierAndSource(sorSourceId, sorPersonId);
        if (sorPerson == null) {
            throw new NotFoundException(String.format("The person resource identified by [/sor/%s/people/%s] URI does not exist.", sorSourceId, sorPersonId));
        }
        if (sorRoleId != null) {
            SorRole sorRole = sorPerson.findSorRoleBySorRoleId(sorRoleId);
            if (sorRole == null) {
                throw new NotFoundException(String.format("The role resource identified by [/sor/%s/people/%s/roles/%s] URI does not exist.", sorSourceId, sorPersonId, sorRoleId));
            }
            ret.put("role", sorRole);
        }
        ret.put("person", sorPerson);
        return ret;
    }

    private void updateSorRoleWithIncomingData(SorPerson person, SorRole sorRole, RoleRepresentation roleRepresentation) {
        this.copyBasicRoleDataFromIncomingRepresentation(sorRole, roleRepresentation);
        sorRole.getEmailAddresses().clear();
        if (roleRepresentation.emails != null) {
            this.copyEmailDataFromIncomingRepresentation(sorRole, roleRepresentation.emails);
        }
        sorRole.getPhones().clear();
        if (roleRepresentation.phones != null) {
            this.copyPhoneDataFromIncomingRepresentation(sorRole, roleRepresentation.phones);
        }
        sorRole.getAddresses().clear();
        if (roleRepresentation.addresses != null) {
            this.copyAddressDataFromIncomingRepresentation(sorRole, roleRepresentation.addresses);
        }
    }

    private SorRole buildSorRoleFrom(SorPerson person, RoleRepresentation roleRepresentation) {
        SorRole sorRole = person.createRole(this.referenceRepository.findType(Type.DataTypes.AFFILIATION, roleRepresentation.affiliation));
        if (roleRepresentation.roleId != null) {
            sorRole.setSorId(roleRepresentation.roleId);
        }
        this.copyBasicRoleDataFromIncomingRepresentation(sorRole, roleRepresentation);
        this.copyEmailDataFromIncomingRepresentation(sorRole, roleRepresentation.emails);
        this.copyPhoneDataFromIncomingRepresentation(sorRole, roleRepresentation.phones);
        this.copyAddressDataFromIncomingRepresentation(sorRole, roleRepresentation.addresses);
        person.addRole(sorRole);
        return sorRole;
    }

    private void copyBasicRoleDataFromIncomingRepresentation(SorRole sorRole, RoleRepresentation roleRepresentation) {
        sorRole.setPersonStatus(this.referenceRepository.findType(Type.DataTypes.STATUS, (Enum)Type.PersonStatusTypes.ACTIVE));
        sorRole.setTitle(roleRepresentation.title);
        this.setOrganizationalUnit(sorRole, roleRepresentation.organizationalUnit);
        this.setSystemOfRecord(sorRole, roleRepresentation.systemOfRecord);
        sorRole.setStart(roleRepresentation.startDate);
        if (roleRepresentation.endDate != null) {
            sorRole.setEnd(roleRepresentation.endDate);
        }
        if (roleRepresentation.percentage != null) {
            sorRole.setPercentage(Integer.parseInt(roleRepresentation.percentage));
        }
        this.setSponsorInfo(sorRole, this.referenceRepository.findType(Type.DataTypes.SPONSOR, roleRepresentation.sponsorType), roleRepresentation);
    }

    private void copyEmailDataFromIncomingRepresentation(SorRole sorRole, List<RoleRepresentation.Email> emailsRepresentation) {
        for (RoleRepresentation.Email e : emailsRepresentation) {
            EmailAddress email = sorRole.createEmailAddress();
            email.setAddress(e.address);
            email.setAddressType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, e.type));
            sorRole.addEmailAddress(email);
        }
    }

    private void copyPhoneDataFromIncomingRepresentation(SorRole sorRole, List<RoleRepresentation.Phone> phonesRepresentation) {
        for (RoleRepresentation.Phone ph : phonesRepresentation) {
            Phone phone = sorRole.createPhone();
            phone.setNumber(ph.number);
            phone.setAddressType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, ph.addressType));
            phone.setPhoneType(this.referenceRepository.findType(Type.DataTypes.PHONE, ph.type));
            if (ph.phoneLineOrder != null) {
                phone.setPhoneLineOrder(Integer.valueOf(Integer.parseInt(ph.phoneLineOrder)));
            } else {
                phone.setPhoneLineOrder(this.DEFAULT_PHONE_LINE_ORDER);
            }
            phone.setCountryCode(ph.countryCode);
            phone.setAreaCode(ph.areaCode);
            phone.setExtension(ph.extension);
            sorRole.addPhone(phone);
        }
    }

    private void copyAddressDataFromIncomingRepresentation(SorRole sorRole, List<RoleRepresentation.Address> addressesRepresentation) {
        for (RoleRepresentation.Address a : addressesRepresentation) {
            Address address = sorRole.createAddress();
            address.setType(this.referenceRepository.findType(Type.DataTypes.ADDRESS, a.type));
            address.setLine1(a.line1);
            address.setLine2(a.line2);
            address.setLine3(a.line3);
            address.setCity(a.city);
            address.setPostalCode(a.postalCode);
            Country country = this.referenceRepository.getCountryByCode(a.countryCode);
            address.setCountry(country);
            if (country != null) {
                address.setRegion(this.referenceRepository.getRegionByCodeAndCountryId(a.regionCode, country.getCode()));
            }
            sorRole.addAddress(address);
        }
    }

    private void setSponsorInfo(SorRole sorRole, Type type, RoleRepresentation roleRepresentation) {
        sorRole.setSponsorType(type);
        if (type.getDescription().equals(Type.SponsorTypes.ORG_UNIT.name())) {
            try {
                OrganizationalUnit org = this.referenceRepository.getOrganizationalUnitByCode(roleRepresentation.sponsorId);
                sorRole.setSponsorId(org.getId());
            }
            catch (Exception exception) {
                throw new NotFoundException(String.format("The department identified by [%s] does not exist", roleRepresentation.sponsorId));
            }
        }
        if (type.getDescription().equals(Type.SponsorTypes.PERSON.name())) {
            String sponsorIdType = roleRepresentation.sponsorIdType != null ? roleRepresentation.sponsorIdType : this.preferredPersonIdentifierType;
            try {
                Person person = this.personService.findPersonByIdentifier(sponsorIdType, roleRepresentation.sponsorId);
                sorRole.setSponsorId(person.getId());
            }
            catch (Exception exception) {
                throw new NotFoundException(String.format("The sponsor identified by [%s] does not exist", roleRepresentation.sponsorId));
            }
        }
    }

    private void setOrganizationalUnit(SorRole sorRole, String organizationalUnitCode) {
        try {
            OrganizationalUnit org = this.referenceRepository.getOrganizationalUnitByCode(organizationalUnitCode);
            sorRole.setOrganizationalUnit(org);
        }
        catch (Exception exception) {
            throw new NotFoundException(String.format("The department identified by [%s] does not exist", organizationalUnitCode));
        }
    }

    private void setSystemOfRecord(SorRole sorRole, String systemOfRecord) {
        try {
            SystemOfRecord sor = this.referenceRepository.findSystemOfRecord(systemOfRecord);
            sorRole.setSystemOfRecord(sor);
        }
        catch (Exception exception) {
            throw new NotFoundException(String.format("The system or record identified by [%s] does not exist", systemOfRecord));
        }
    }
}

