/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources;

import com.sun.jersey.api.NotFoundException;
import com.sun.jersey.api.representation.Form;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.PersonNotFoundException;
import org.openregistry.core.domain.sor.ReconciliationCriteria;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.service.PersonService;
import org.openregistry.core.service.ServiceExecutionResult;
import org.openregistry.core.service.reconciliation.PersonMatch;
import org.openregistry.core.service.reconciliation.ReconciliationResult;
import org.openregistry.core.utils.ValidationUtils;
import org.openregistry.core.web.resources.PeopleResourceUtils;
import org.openregistry.core.web.resources.representations.ErrorsResponseRepresentation;
import org.openregistry.core.web.resources.representations.LinkRepresentation;
import org.openregistry.core.web.resources.representations.PersonRequestRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.Assert;

@Named
@Singleton
@Path(value="/sor/{sorSourceId}/people")
public final class SystemOfRecordPeopleResource {
    private static final String FORCE_ADD_FLAG = "y";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Context
    UriInfo uriInfo;
    private final PersonService personService;
    private final ReferenceRepository referenceRepository;
    @Resource(name="reconciliationCriteriaFactory")
    private ObjectFactory<ReconciliationCriteria> reconciliationCriteriaObjectFactory;
    @Resource
    private String preferredPersonIdentifierType;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$openregistry$core$service$reconciliation$ReconciliationResult$ReconciliationType;

    @Inject
    public SystemOfRecordPeopleResource(PersonService personService, ReferenceRepository referenceRepository) {
        this.personService = personService;
        this.referenceRepository = referenceRepository;
    }

    /*
     * Exception decompiling
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response processIncomingPerson(PersonRequestRepresentation personRequestRepresentation, @PathParam(value="sorSourceId") String sorSourceId, @QueryParam(value="force") String forceAdd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @DELETE
    @Path(value="{sorPersonId}")
    public Response deletePerson(@PathParam(value="sorSourceId") String sorSourceId, @PathParam(value="sorPersonId") String sorPersonId, @QueryParam(value="mistake") @DefaultValue(value="false") boolean mistake, @QueryParam(value="terminationType") @DefaultValue(value="UNSPECIFIED") String terminationType) {
        try {
            if (!this.personService.deleteSystemOfRecordPerson(sorSourceId, sorPersonId, mistake, terminationType)) {
                throw new WebApplicationException((Throwable)new RuntimeException(String.format("Unable to Delete SorPerson for SoR [ %s ] with ID [ %s ]", sorSourceId, sorPersonId)), 500);
            }
            this.logger.debug("The SOR Person resource has been successfully DELETEd");
            return null;
        }
        catch (PersonNotFoundException personNotFoundException) {
            throw new NotFoundException(String.format("The system of record person resource identified by /sor/%s/people/%s URI does not exist", sorSourceId, sorPersonId));
        }
    }

    @PUT
    @Path(value="{sorPersonId}")
    @Consumes(value={"application/xml"})
    public Response updateIncomingPerson(@PathParam(value="sorSourceId") String sorSourceId, @PathParam(value="sorPersonId") String sorPersonId, PersonRequestRepresentation request) {
        SorPerson sorPerson = this.findPersonOrThrowNotFoundException(sorSourceId, sorPersonId);
        PeopleResourceUtils.buildModifiedSorPerson((PersonRequestRepresentation)request, (SorPerson)sorPerson, (ReferenceRepository)this.referenceRepository);
        try {
            ServiceExecutionResult result = this.personService.updateSorPerson(sorPerson);
            if (!result.getValidationErrors().isEmpty()) {
                this.logger.info("The incoming person payload did not pass validation. Validation errors: " + result.getValidationErrors());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorsResponseRepresentation(ValidationUtils.buildValidationErrorsResponseAsList((Set)result.getValidationErrors()))).type("application/xml").build();
            }
        }
        catch (IllegalStateException e) {
            return Response.status((int)409).entity((Object)new ErrorsResponseRepresentation(Arrays.asList(e.getMessage()))).type("application/xml").build();
        }
        return null;
    }

    private URI buildPersonResourceUri(Person person) {
        Identifier identifier = (Identifier)person.getPrimaryIdentifiersByType().get(this.preferredPersonIdentifierType);
        Assert.notNull((Object)identifier, (String)("The person must have at least one id of the preferred configured type which is <" + this.preferredPersonIdentifierType + ">"));
        return this.uriInfo.getAbsolutePathBuilder().path(this.preferredPersonIdentifierType).path(identifier.getValue()).build(new Object[0]);
    }

    private LinkRepresentation buildLinksToConflictingPeopleFound(List<PersonMatch> matches) {
        if (matches.isEmpty()) {
            throw new IllegalStateException("Person matches cannot be empty if reconciliation result is <MAYBE>");
        }
        ArrayList<LinkRepresentation.Link> links = new ArrayList<LinkRepresentation.Link>();
        for (PersonMatch match : matches) {
            links.add(new LinkRepresentation.Link("person", this.buildPersonResourceUri(match.getPerson()).toString()));
        }
        return new LinkRepresentation(links);
    }

    private Form buildPersonActivationKeyRepresentation(Person person) {
        Form f = new Form();
        f.putSingle("activationKey", person.getCurrentActivationKey().asString());
        return f;
    }

    private SorPerson findPersonOrThrowNotFoundException(String sorSourceId, String sorPersonId) {
        SorPerson sorPerson = this.personService.findBySorIdentifierAndSource(sorSourceId, sorPersonId);
        if (sorPerson == null) {
            throw new NotFoundException(String.format("The person resource identified by [/sor/%s/people/%s] URI does not exist.", sorSourceId, sorPersonId));
        }
        return sorPerson;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$openregistry$core$service$reconciliation$ReconciliationResult$ReconciliationType() {
        if ($SWITCH_TABLE$org$openregistry$core$service$reconciliation$ReconciliationResult$ReconciliationType != null) {
            return $SWITCH_TABLE$org$openregistry$core$service$reconciliation$ReconciliationResult$ReconciliationType;
        }
        int[] nArray = new int[ReconciliationResult.ReconciliationType.values().length];
        try {
            nArray[ReconciliationResult.ReconciliationType.EXACT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReconciliationResult.ReconciliationType.MAYBE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReconciliationResult.ReconciliationType.MISMATCH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReconciliationResult.ReconciliationType.NONE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$openregistry$core$service$reconciliation$ReconciliationResult$ReconciliationType = nArray;
        return nArray;
    }
}

