/*
 * Decompiled with CFR 0.152.
 */
package org.openregistry.core.web.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openregistry.core.domain.IdentifierType;
import org.openregistry.core.domain.Type;
import org.openregistry.core.domain.sor.ReconciliationCriteria;
import org.openregistry.core.domain.sor.SorName;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.repository.ReferenceRepository;
import org.openregistry.core.web.resources.representations.PersonRequestRepresentation;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PeopleResourceUtils {
    private PeopleResourceUtils() {
    }

    public static ReconciliationCriteria buildReconciliationCriteriaFrom(PersonRequestRepresentation request, ObjectFactory<ReconciliationCriteria> factory, ReferenceRepository referenceRepository) {
        ReconciliationCriteria rc = (ReconciliationCriteria)factory.getObject();
        rc.getSorPerson().setSourceSor(request.systemOfRecordId);
        rc.getSorPerson().setSorId(request.systemOfRecordPersonId);
        for (PersonRequestRepresentation.Name requestName : request.names) {
            SorName name = rc.getSorPerson().addName();
            PeopleResourceUtils.updateName((SorName)name, (PersonRequestRepresentation.Name)requestName, (ReferenceRepository)referenceRepository);
        }
        rc.getSorPerson().setDateOfBirth(request.dateOfBirth);
        rc.getSorPerson().setSsn(request.ssn);
        rc.getSorPerson().setGender(request.gender);
        if (request.reconciliation != null) {
            if (request.reconciliation.address != null) {
                rc.setAddressLine1(request.reconciliation.address.addressLine1);
                rc.setAddressLine2(request.reconciliation.address.addressLine2);
                rc.setCity(request.reconciliation.address.city);
                rc.setRegion(request.reconciliation.address.region);
                rc.setPostalCode(request.reconciliation.address.postalCode);
            }
            if (!request.reconciliation.emails.isEmpty()) {
                rc.setEmailAddress(((PersonRequestRepresentation.Reconciliation.Email)request.reconciliation.emails.get((int)0)).email);
            }
            if (!request.reconciliation.phones.isEmpty()) {
                PeopleResourceUtils.updatePhone((ReconciliationCriteria)rc, (String)((PersonRequestRepresentation.Reconciliation.Phone)request.reconciliation.phones.get((int)0)).phoneNumber);
            }
            if (!request.reconciliation.identifiers.isEmpty()) {
                for (PersonRequestRepresentation.Reconciliation.Identifier identifier : request.reconciliation.identifiers) {
                    IdentifierType identifierType = referenceRepository.findIdentifierType(identifier.identifierType);
                    Assert.notNull((Object)identifierType);
                    rc.getIdentifiersByType().put(identifierType, identifier.identifierValue);
                }
            }
        }
        return rc;
    }

    private static void updateName(SorName name, PersonRequestRepresentation.Name n, ReferenceRepository referenceRepository) {
        name.setFamily(n.lastName);
        name.setGiven(n.firstName);
        name.setMiddle(n.middleName);
        name.setSuffix(n.suffix);
        name.setPrefix(n.prefix);
        Type type = PeopleResourceUtils.processNameType((ReferenceRepository)referenceRepository, (String)n.nameType);
        name.setType(type);
    }

    private static void updatePhone(ReconciliationCriteria rc, String phoneNumber) {
        String countryCode = null;
        String areaCode = null;
        String number = null;
        String extension = null;
        String expression = "^(\\+(\\d{1,3})[- ])?(\\(?(\\d{3})\\)?[- ]?)?((\\d{3})[- ]?(\\d{4}))([ ]?x(\\d+))?$";
        Matcher matcher = Pattern.compile(expression).matcher(phoneNumber);
        if (matcher.matches()) {
            countryCode = matcher.group(2);
            areaCode = matcher.group(4);
            number = String.valueOf(matcher.group(6)) + matcher.group(7);
            extension = matcher.group(9);
        }
        rc.setPhoneCountryCode(countryCode);
        rc.setPhoneAreaCode(areaCode);
        rc.setPhoneNumber(number);
        rc.setPhoneExtension(extension);
    }

    public static void buildModifiedSorPerson(PersonRequestRepresentation request, SorPerson sorPerson, ReferenceRepository referenceRepository) {
        sorPerson.setDateOfBirth(request.dateOfBirth);
        sorPerson.setSsn(request.ssn);
        sorPerson.setGender(request.gender);
        sorPerson.getNames().clear();
        for (PersonRequestRepresentation.Name n : request.names) {
            SorName name = sorPerson.addName();
            PeopleResourceUtils.updateName((SorName)name, (PersonRequestRepresentation.Name)n, (ReferenceRepository)referenceRepository);
        }
    }

    public static Type processNameType(ReferenceRepository referenceRepository, String nameType) {
        Type type;
        if (nameType != null && (type = referenceRepository.findType(Type.DataTypes.NAME, nameType)) != null) {
            return type;
        }
        return referenceRepository.findType(Type.DataTypes.NAME, (Enum)Type.NameTypes.FORMAL);
    }
}

